/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.request;

import com.github.tlrx.elasticsearch.test.EsSetupRuntimeException;
import com.github.tlrx.elasticsearch.test.provider.JSONProvider;
import com.github.tlrx.elasticsearch.test.request.Request;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;

public class Index
implements Request<Void> {
    private final IndexRequest request;

    public Index(String index, String type) {
        this.request = new IndexRequest(index, type).refresh(true);
    }

    public Index(String index, String type, String id) {
        this(index, type);
        this.request.id(id);
    }

    public Index withSource(String source) {
        this.request.source(source);
        return this;
    }

    public Index withSource(JSONProvider jsonProvider) {
        this.request.source(jsonProvider.toJson());
        return this;
    }

    @Override
    public Void execute(Client client) throws ElasticsearchException {
        try {
            IndexResponse response = (IndexResponse)client.index(this.request).get();
        }
        catch (Exception e) {
            throw new EsSetupRuntimeException(e);
        }
        return null;
    }

    public String toString() {
        return "index [index='" + this.request.index() + "'," + "type='" + this.request.type() + '\'' + ']';
    }
}

