/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.support.junit.rules;

import com.github.tlrx.elasticsearch.test.support.junit.handlers.ClassLevelElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.ElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.FieldLevelElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.rules.AbstractElasticsearchRule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.junit.runners.model.TestClass;

public class ElasticsearchClassRule
extends AbstractElasticsearchRule {
    private final TestClass testClass;

    public ElasticsearchClassRule(Map<String, Object> context, TestClass testClass) {
        super(context);
        this.testClass = testClass;
    }

    @Override
    protected void before(Collection<Annotation> annotations) throws Exception {
        this.executeBeforeOrAfterClassHandlers(true, annotations);
    }

    @Override
    protected void after(Collection<Annotation> annotations) throws Exception {
        this.executeBeforeOrAfterClassHandlers(false, annotations);
    }

    private void executeBeforeOrAfterClassHandlers(boolean isBefore, Collection<Annotation> annotations) throws Exception {
        if (annotations != null && !annotations.isEmpty()) {
            for (ElasticsearchAnnotationHandler handler : this.handlers) {
                if (!(handler instanceof ClassLevelElasticsearchAnnotationHandler)) continue;
                ClassLevelElasticsearchAnnotationHandler classHandler = (ClassLevelElasticsearchAnnotationHandler)handler;
                if (isBefore) {
                    classHandler.beforeClass(this.testClass, this.context);
                }
                for (Annotation annotation : annotations) {
                    if (!handler.support(annotation)) continue;
                    if (isBefore) {
                        classHandler.handleBeforeClass(annotation, this.testClass, this.context);
                        continue;
                    }
                    classHandler.handleAfterClass(annotation, this.testClass, this.context);
                }
                if (isBefore) continue;
                classHandler.afterClass(this.testClass, this.context);
            }
        }
    }

    public void executeBeforeTestExecution(Object instance) throws Exception {
        for (ElasticsearchAnnotationHandler handler : this.handlers) {
            if (!(handler instanceof FieldLevelElasticsearchAnnotationHandler)) continue;
            FieldLevelElasticsearchAnnotationHandler fieldHandler = (FieldLevelElasticsearchAnnotationHandler)handler;
            for (Field field : this.getAllFields(instance.getClass())) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!handler.support(annotation)) continue;
                    fieldHandler.handleField(annotation, instance, this.context, field);
                }
            }
        }
    }
}

