/*
 * Decompiled with CFR 0.152.
 */
package com.github.tminglei.slickpg;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.SQLException;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class PgPostGISSupportUtils$ {
    public static final PgPostGISSupportUtils$ MODULE$;
    private final ThreadLocal<WKTWriter> wktWriterHolder;
    private final ThreadLocal<WKTReader> wktReaderHolder;
    private final ThreadLocal<WKBWriter> wkbWriterHolder;
    private final ThreadLocal<WKBWriter> wkb3DWriterHolder;
    private final ThreadLocal<WKBReader> wkbReaderHolder;

    static {
        new PgPostGISSupportUtils$();
    }

    private ThreadLocal<WKTWriter> wktWriterHolder() {
        return this.wktWriterHolder;
    }

    private ThreadLocal<WKTReader> wktReaderHolder() {
        return this.wktReaderHolder;
    }

    private ThreadLocal<WKBWriter> wkbWriterHolder() {
        return this.wkbWriterHolder;
    }

    private ThreadLocal<WKBWriter> wkb3DWriterHolder() {
        return this.wkb3DWriterHolder;
    }

    private ThreadLocal<WKBReader> wkbReaderHolder() {
        return this.wkbReaderHolder;
    }

    public String toLiteral(Geometry geom) {
        if (this.wktWriterHolder().get() == null) {
            this.wktWriterHolder().set(new WKTWriter());
        }
        return this.wktWriterHolder().get().write(geom);
    }

    public <T> T fromLiteral(String value) {
        Tuple2<Object, String> tuple2;
        if (this.wktReaderHolder().get() == null) {
            this.wktReaderHolder().set(new WKTReader());
        }
        if ((tuple2 = this.splitRSIDAndWKT(value)) != null) {
            Geometry geom;
            int srid = tuple2._1$mcI$sp();
            String wkt = (String)tuple2._2();
            Geometry geometry = geom = wkt.startsWith("00") || wkt.startsWith("01") ? (Geometry)this.fromBytes(WKBReader.hexToBytes((String)wkt)) : this.wktReaderHolder().get().read(wkt);
            if (srid != -1) {
                geom.setSRID(srid);
            }
            Geometry geometry2 = geom;
            return (T)geometry2;
        }
        throw new MatchError(tuple2);
    }

    public byte[] toBytes(Geometry geom) {
        byte[] byArray;
        if (geom == null || geom.getCoordinate() == null || Double.isNaN(geom.getCoordinate().z)) {
            if (this.wkbWriterHolder().get() == null) {
                this.wkbWriterHolder().set(new WKBWriter(2, true));
            }
            byArray = this.wkbWriterHolder().get().write(geom);
        } else {
            if (this.wkb3DWriterHolder().get() == null) {
                this.wkb3DWriterHolder().set(new WKBWriter(3, true));
            }
            byArray = this.wkb3DWriterHolder().get().write(geom);
        }
        return byArray;
    }

    private <T> T fromBytes(byte[] bytes) {
        if (this.wkbReaderHolder().get() == null) {
            this.wkbReaderHolder().set(new WKBReader());
        }
        return (T)this.wkbReaderHolder().get().read(bytes);
    }

    private Tuple2<Object, String> splitRSIDAndWKT(String value) {
        Tuple2 tuple2;
        if (value.startsWith("SRID=")) {
            int index = value.indexOf(59, 5);
            if (index == -1) {
                throw new SQLException("Error parsing Geometry - SRID not delimited with ';' ");
            }
            int srid = Integer.parseInt(value.substring(0, index));
            String wkt = value.substring(index + 1);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)srid), (Object)wkt);
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)value);
        }
        return tuple2;
    }

    private PgPostGISSupportUtils$() {
        MODULE$ = this;
        this.wktWriterHolder = new ThreadLocal();
        this.wktReaderHolder = new ThreadLocal();
        this.wkbWriterHolder = new ThreadLocal();
        this.wkb3DWriterHolder = new ThreadLocal();
        this.wkbReaderHolder = new ThreadLocal();
    }
}

