/*
 * Decompiled with CFR 0.152.
 */
package jscover;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import jscover.Configuration;
import jscover.util.IoUtils;
import jscover.util.PatternMatcher;
import jscover.util.PatternMatcherRegEx;
import jscover.util.PatternMatcherString;
import org.mozilla.javascript.CompilerEnvirons;

public class ConfigurationCommon
extends Configuration {
    private static final Logger logger = Logger.getLogger(ConfigurationCommon.class.getName());
    public static final String ONLY_INSTRUMENT_REG_PREFIX = "--only-instrument-reg=";
    public static final String NO_INSTRUMENT_PREFIX = "--no-instrument=";
    public static final String NO_INSTRUMENT_REG_PREFIX = "--no-instrument-reg=";
    public static final String INCLUDE_UNLOADED_JS_PREFIX = "--include-unloaded-js";
    public static final String JS_VERSION_PREFIX = "--js-version=";
    public static final String NO_BRANCH_PREFIX = "--no-branch";
    public static final String DETECT_COALESCE_PREFIX = "--detect-coalesce";
    public static final String NO_FUNCTION_PREFIX = "--no-function";
    public static final String LOCAL_STORAGE_PREFIX = "--local-storage";
    public static final String ISOLATE_BROWSER_PREFIX = "--isolate-browser";
    public static final String LOG_LEVEL = "--log=";
    protected boolean showHelp;
    protected boolean invalid;
    protected boolean includeBranch = true;
    protected boolean detectCoalesce;
    protected boolean includeFunction = true;
    protected boolean localStorage;
    protected boolean isolateBrowser;
    protected final List<PatternMatcher> patternMatchers = new ArrayList<PatternMatcher>();
    private boolean includeUnloadedJS;
    protected int JSVersion = 150;
    protected CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
    protected boolean defaultSkip;
    protected IoUtils ioUtils = IoUtils.getInstance();
    protected Level logLevel = Level.SEVERE;

    public ConfigurationCommon() {
        this.compilerEnvirons.setRecordingComments(true);
    }

    public void setIncludeBranch(boolean includeBranch) {
        this.includeBranch = includeBranch;
    }

    public void setDetectCoalesce(boolean detectCoalesce) {
        this.detectCoalesce = detectCoalesce;
    }

    public void setIncludeFunction(boolean includeFunction) {
        this.includeFunction = includeFunction;
    }

    public void setLocalStorage(boolean localStorage) {
        this.localStorage = localStorage;
    }

    public void setIncludeUnloadedJS(boolean includeUnloadedJS) {
        this.includeUnloadedJS = includeUnloadedJS;
    }

    public void setIsolateBrowser(boolean isolateBrowser) {
        this.isolateBrowser = isolateBrowser;
    }

    public void setJSVersion(int JSVersion) {
        this.JSVersion = JSVersion;
    }

    public Boolean showHelp() {
        return this.showHelp;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isIncludeUnloadedJS() {
        return this.includeUnloadedJS;
    }

    public boolean isIncludeBranch() {
        return this.includeBranch;
    }

    public boolean isDetectCoalesce() {
        return this.detectCoalesce;
    }

    public boolean isIncludeFunction() {
        return this.includeFunction;
    }

    public boolean isLocalStorage() {
        return this.localStorage;
    }

    public boolean isolateBrowser() {
        return this.isolateBrowser;
    }

    public int getJSVersion() {
        return this.JSVersion;
    }

    public CompilerEnvirons getCompilerEnvirons() {
        return this.compilerEnvirons;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public boolean skipInstrumentation(String uri) {
        for (PatternMatcher patternMatcher : this.patternMatchers) {
            Boolean instrumentIt = patternMatcher.matches(uri);
            if (instrumentIt == null) continue;
            logger.log(Level.FINEST, "Matched URI ''{0}'' Pattern ''{1}'' Skip {2}", new Object[]{uri, patternMatcher, instrumentIt});
            return instrumentIt;
        }
        return this.defaultSkip;
    }

    protected void setInvalid(String message) {
        System.err.println(message);
        this.showHelp = true;
        this.invalid = true;
    }

    public void addNoInstrument(String arg) {
        String uri = arg.substring(NO_INSTRUMENT_PREFIX.length());
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        this.patternMatchers.add(new PatternMatcherString(uri));
    }

    public void addOnlyInstrumentReg(String arg) {
        String patternString = arg.substring(ONLY_INSTRUMENT_REG_PREFIX.length());
        if (patternString.startsWith("/")) {
            patternString = patternString.substring(1);
        }
        this.defaultSkip = true;
        try {
            this.patternMatchers.add(PatternMatcherRegEx.getIncludePatternMatcher(patternString));
        }
        catch (PatternSyntaxException e) {
            this.setInvalid(String.format("Invalid pattern '%s'", patternString));
            e.printStackTrace(System.err);
        }
    }

    public void addNoInstrumentReg(String arg) {
        String patternString = arg.substring(NO_INSTRUMENT_REG_PREFIX.length());
        if (patternString.startsWith("/")) {
            patternString = patternString.substring(1);
        }
        try {
            this.patternMatchers.add(PatternMatcherRegEx.getExcludePatternMatcher(patternString));
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace(System.err);
            this.setInvalid(String.format("Invalid pattern '%s'", patternString));
        }
    }

    protected boolean parseArg(String arg) {
        if (arg.equals("-h") || arg.equals("--help")) {
            this.showHelp = true;
        } else if (arg.equals(NO_BRANCH_PREFIX)) {
            this.includeBranch = false;
        } else if (arg.equals(NO_FUNCTION_PREFIX)) {
            this.includeFunction = false;
        } else if (arg.equals(DETECT_COALESCE_PREFIX)) {
            this.detectCoalesce = true;
        } else if (arg.equals(INCLUDE_UNLOADED_JS_PREFIX)) {
            this.includeUnloadedJS = true;
        } else if (arg.equals(LOCAL_STORAGE_PREFIX)) {
            if (this.isolateBrowser) {
                throw new IllegalArgumentException("Cannot combine '--local-storage' and '--isolate-browser'.");
            }
            this.localStorage = true;
        } else if (arg.equals(ISOLATE_BROWSER_PREFIX)) {
            if (this.localStorage) {
                throw new IllegalArgumentException("Cannot combine '--local-storage' and '--isolate-browser'.");
            }
            this.isolateBrowser = true;
        } else if (arg.startsWith(NO_INSTRUMENT_PREFIX)) {
            this.addNoInstrument(arg);
        } else if (arg.startsWith(NO_INSTRUMENT_REG_PREFIX)) {
            this.addNoInstrumentReg(arg);
        } else if (arg.startsWith(ONLY_INSTRUMENT_REG_PREFIX)) {
            this.addOnlyInstrumentReg(arg);
        } else if (arg.startsWith(JS_VERSION_PREFIX)) {
            this.JSVersion = (int)(Float.valueOf(arg.substring(JS_VERSION_PREFIX.length())).floatValue() * 100.0f);
        } else if (arg.startsWith(LOG_LEVEL)) {
            this.logLevel = Level.parse(arg.substring(LOG_LEVEL.length()));
        } else {
            return false;
        }
        return true;
    }
}

