/*
 * Decompiled with CFR 0.152.
 */
package jscover;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jscover.ExitHelper;
import jscover.MainHelper;
import jscover.filesystem.ConfigurationForFS;
import jscover.filesystem.FileSystemInstrumenter;
import jscover.server.ConfigurationForServer;
import jscover.server.WebDaemon;
import jscover.stdout.ConfigurationForStdOut;
import jscover.stdout.StdOutInstrumenter;
import jscover.util.IoService;
import jscover.util.IoUtils;
import jscover.util.LoggerUtils;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    public static final String HELP_PREFIX1 = "-h";
    public static final String CHARSET_PREFIX = "encoding";
    public static final String HELP_PREFIX2 = "--help";
    public static final String VERSION_PREFIX1 = "-V";
    public static final String VERSION_PREFIX2 = "--version";
    public static final String SERVER_PREFIX = "-ws";
    public static final String FILESYSTEM_PREFIX = "-fs";
    public static final String GENERATE_FILES_PREFIX = "-gf";
    public static final String STDOUT_PREFIX = "-io";
    public static final String REG_TEST_PREFIX = "-regex-test";
    public static final Properties properties = new Properties();
    public static final String reportSrcSubDir = "original-src";
    private String manifestName = "MANIFEST.MF";
    private List<String> dependantClasses = new ArrayList<String>(){
        {
            this.add("org.mozilla.javascript.ast.AstNode");
        }
    };
    private ExitHelper exitHelper = new ExitHelper();
    private MainHelper mainHelper = new MainHelper();
    private WebDaemon webDaemon = new WebDaemon();
    private FileSystemInstrumenter fileSystemInstrumenter = new FileSystemInstrumenter();
    private StdOutInstrumenter stdOutInstrumenter = new StdOutInstrumenter();
    private IoUtils ioUtils = IoUtils.getInstance();
    private IoService ioService = new IoService(false);
    private boolean showHelp;
    private boolean showCharsets;
    private boolean isRegExpTest;
    private boolean printVersion;
    private boolean isServer;
    private boolean isFileSystem;
    private boolean isGenerateFiles;
    private boolean isStdOut;
    private int exitStatus;

    public void initialize() {
        try {
            properties.load(Main.class.getResourceAsStream("configuration.properties"));
            this.mainHelper.checkDependantClasses(this.dependantClasses, this.manifestName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        new Main().runMain(args);
    }

    public void stop() {
        this.webDaemon.stop();
    }

    public void runMain(String[] args) {
        logger.log(Level.INFO, "Args: {0}", this.getArgsLogger(args));
        this.parse(args);
        this.initialize();
        this.runJSCover(args);
        if (LoggerUtils.getInstance().isExceptionThrown()) {
            this.exitStatus = 1;
        }
        if (this.exitStatus != 0) {
            this.exitHelper.exit(this.exitStatus);
        }
    }

    public Object getArgsLogger(final String[] args) {
        return new Object(){

            public String toString() {
                return Main.this.logArgs(args);
            }
        };
    }

    String logArgs(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public void runJSCover(String[] args) {
        if (this.printVersion().booleanValue()) {
            System.out.println(this.getVersionText());
        } else if (this.isServer().booleanValue()) {
            this.runServer(ConfigurationForServer.parse(args));
        } else if (this.isFileSystem()) {
            this.runFileSystem(ConfigurationForFS.parse(args));
        } else if (this.isStdOut()) {
            this.runSingleFile(ConfigurationForStdOut.parse(args));
        } else if (this.showCharSets().booleanValue()) {
            System.out.println("Valid encodings:");
            SortedMap<String, Charset> charSet = Charset.availableCharsets();
            for (String charSetName : charSet.keySet()) {
                System.out.println(charSetName);
            }
            System.out.println("Default is: " + Charset.defaultCharset().name());
        } else if (this.isGenerateFiles() && (args.length == 2 || args.length == 3)) {
            File dest = new File(args[args.length - 1]);
            this.ioService.generateJSCoverFilesForWebServer(dest, properties.getProperty("version"));
            if (args.length == 3) {
                File src = new File(args[1]);
                this.ioUtils.copyDir(src, new File(dest, reportSrcSubDir));
            }
        } else if (this.isRegExpTest() && args.length == 3) {
            Pattern pattern = Pattern.compile(args[1]);
            Matcher match = pattern.matcher(args[2]);
            if (match.matches()) {
                System.out.println("Matched");
            } else {
                System.out.println("No match");
            }
        } else {
            System.out.println(this.getHelpText());
        }
    }

    public String getHelpText() {
        return this.ioUtils.toString(this.getClass().getResourceAsStream("help.txt"));
    }

    public String getVersionText() {
        return "JSCover version: " + properties.getProperty("version");
    }

    public void runFileSystem(ConfigurationForFS configuration) {
        configuration.setProperties(properties);
        if (configuration.isInvalid()) {
            this.exitStatus = 1;
        }
        if (configuration.showHelp().booleanValue()) {
            System.out.println(configuration.getHelpText());
        } else {
            this.fileSystemInstrumenter.run(configuration);
        }
    }

    public void runServer(ConfigurationForServer configuration) {
        configuration.setProperties(properties);
        if (configuration.isInvalid()) {
            this.exitStatus = 1;
        }
        if (configuration.showHelp().booleanValue()) {
            System.out.println(configuration.getHelpText());
        } else {
            try {
                this.webDaemon.start(configuration);
            }
            catch (SocketException e) {
                if (this.webDaemon.running) {
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.webDaemon.stop();
            }
        }
    }

    private void runSingleFile(ConfigurationForStdOut configuration) {
        configuration.setProperties(properties);
        if (configuration.isInvalid()) {
            this.exitStatus = 1;
        }
        if (configuration.showHelp().booleanValue()) {
            System.out.println(configuration.getHelpText());
        } else {
            this.stdOutInstrumenter.run(configuration);
        }
    }

    public Main parse(String[] args) {
        for (String arg : args) {
            this.parse(arg);
        }
        if (!this.validOptions()) {
            this.exitStatus = 1;
            this.showHelp = true;
        }
        return this;
    }

    private void parse(String arg) {
        if (arg.equals(HELP_PREFIX1) || arg.equals(HELP_PREFIX2)) {
            this.showHelp = true;
        } else if (arg.equals(VERSION_PREFIX1) || arg.equals(VERSION_PREFIX2)) {
            this.printVersion = true;
        } else if (arg.equals(SERVER_PREFIX)) {
            this.isServer = true;
        } else if (arg.equals(FILESYSTEM_PREFIX)) {
            this.isFileSystem = true;
        } else if (arg.equals(STDOUT_PREFIX)) {
            this.isStdOut = true;
        } else if (arg.equals(GENERATE_FILES_PREFIX)) {
            this.isGenerateFiles = true;
        } else if (arg.equals(REG_TEST_PREFIX)) {
            this.isRegExpTest = true;
        } else if (arg.equals(CHARSET_PREFIX)) {
            this.showCharsets = true;
        }
    }

    private boolean validOptions() {
        if (this.isServer && (this.isFileSystem || this.isStdOut) || this.isFileSystem && this.isStdOut) {
            return false;
        }
        return this.isServer || this.isFileSystem || this.isStdOut || this.isGenerateFiles || this.isRegExpTest || this.showHelp || this.printVersion || this.showCharsets;
    }

    public Boolean printVersion() {
        return this.printVersion;
    }

    public Boolean showHelp() {
        return this.showHelp;
    }

    public Boolean showCharSets() {
        return this.showHelp && this.showCharsets;
    }

    public boolean isRegExpTest() {
        return this.isRegExpTest;
    }

    public Boolean isServer() {
        return this.isServer;
    }

    public boolean isFileSystem() {
        return this.isFileSystem;
    }

    public boolean isGenerateFiles() {
        return this.isGenerateFiles;
    }

    public boolean isStdOut() {
        return this.isStdOut;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }
}

