/*
 * Decompiled with CFR 0.152.
 */
package jscover.filesystem;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jscover.ConfigurationCommon;

public class ConfigurationForFS
extends ConfigurationCommon {
    public static final String EXLCUDE_PREFIX = "--exclude=";
    public static final String EXLCUDE_REG_PREFIX = "--exclude-reg=";
    public static final String THREAD_COUNT = "--threads=";
    private final Set<String> excludes = new HashSet<String>();
    private final Set<Pattern> excludeRegs = new HashSet<Pattern>();
    private File srcDir;
    private File destDir;
    private int threads = Runtime.getRuntime().availableProcessors();

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public boolean exclude(String path) {
        for (String exclude : this.excludes) {
            if (!path.startsWith(exclude)) continue;
            return true;
        }
        for (Pattern excludeReg : this.excludeRegs) {
            if (!excludeReg.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public static ConfigurationForFS parse(String[] args) {
        ConfigurationForFS configuration = new ConfigurationForFS();
        for (int i = 0; i < args.length; ++i) {
            configuration.parse(args[i]);
        }
        if (configuration.showHelp) {
            return configuration;
        }
        if (args.length < 3) {
            configuration.setInvalid("A minimum of 3 arguments is required");
            return configuration;
        }
        configuration.validate();
        configuration.compilerEnvirons.setLanguageVersion(configuration.JSVersion);
        return configuration;
    }

    public void validate() {
        if (!this.validSourceDirectory()) {
            this.setInvalid(String.format("Source directory '%s' is invalid", this.srcDir));
        } else if (!this.validDestinationDirectory()) {
            this.setInvalid(String.format("Destination directory '%s' must not be in the source directory", this.destDir));
        }
    }

    protected void parse(String arg) {
        if (super.parseArg(arg)) {
            return;
        }
        if (!arg.startsWith("-fs")) {
            if (arg.startsWith(EXLCUDE_PREFIX)) {
                this.addExclude(arg);
            } else if (arg.startsWith(EXLCUDE_REG_PREFIX)) {
                this.addExcludeReg(arg);
            } else if (arg.startsWith(THREAD_COUNT)) {
                this.threads = Integer.parseInt(arg.substring(THREAD_COUNT.length()));
            } else if (arg.startsWith("-")) {
                this.setInvalid(String.format("JSCover: Unknown option '%s'", arg));
            } else if (this.srcDir == null) {
                this.srcDir = new File(arg);
            } else if (this.destDir == null) {
                this.destDir = new File(arg);
            } else {
                this.setInvalid(String.format("JSCover: Extra command line argument found '%s'", arg));
            }
        }
    }

    public void addExclude(String arg) {
        String uri = arg.substring(EXLCUDE_PREFIX.length());
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        this.excludes.add(uri);
    }

    public void addExcludeReg(String arg) {
        String patternString = arg.substring(EXLCUDE_REG_PREFIX.length());
        try {
            this.excludeRegs.add(Pattern.compile(patternString));
        }
        catch (PatternSyntaxException e) {
            this.setInvalid(String.format("Invalid pattern '%s'", patternString));
            e.printStackTrace(System.err);
        }
    }

    private boolean validSourceDirectory() {
        return this.srcDir.exists() && this.srcDir.isDirectory();
    }

    boolean validDestinationDirectory() {
        return !this.ioUtils.isSubDirectory(this.destDir, this.srcDir);
    }

    public String getHelpText() {
        return this.ioUtils.toString(this.getClass().getResourceAsStream("help.txt"));
    }

    public int getThreads() {
        return this.threads;
    }
}

