/*
 * Decompiled with CFR 0.152.
 */
package jscover.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.filesystem.ConfigurationForFS;
import jscover.instrument.InstrumenterService;
import jscover.instrument.UnloadedSourceProcessor;
import jscover.report.JSONDataSaver;
import jscover.report.ScriptCoverageCount;
import jscover.util.IoService;
import jscover.util.IoUtils;
import jscover.util.LoggerUtils;
import jscover.util.UriFileTranslator;
import jscover.util.UriFileTranslatorNoOp;

public class FileSystemInstrumenter {
    private static final Logger logger = Logger.getLogger(FileSystemInstrumenter.class.getName());
    private IoService ioService;
    private InstrumenterService instrumenterService = new InstrumenterService();
    private IoUtils ioUtils = IoUtils.getInstance();
    private LoggerUtils loggerUtils = LoggerUtils.getInstance();
    private ConfigurationForFS configuration;
    private UnloadedSourceProcessor unloadedSourceProcessor;
    private JSONDataSaver jsonDataSaver = new JSONDataSaver();
    private List<ScriptCoverageCount> unloadJSData = new ArrayList<ScriptCoverageCount>();
    private UriFileTranslator uriFileTranslator = new UriFileTranslatorNoOp();
    private ExecutorService executor = Executors.newFixedThreadPool(5);

    public void run(ConfigurationForFS configuration) {
        this.executor = Executors.newFixedThreadPool(configuration.getThreads());
        this.configuration = configuration;
        this.ioService = new IoService(configuration.isLocalStorage());
        this.loggerUtils.configureLogger(configuration.getLogLevel(), configuration.getDestDir());
        this.unloadedSourceProcessor = new UnloadedSourceProcessor(configuration, configuration.getSrcDir());
        logger.log(Level.INFO, "Starting JSCover {0} file instrumentation", configuration.getVersion());
        this.ioService.generateJSCoverFilesForFileSystem(configuration.getDestDir(), configuration.getVersion());
        this.copyFolder(configuration.getSrcDir(), configuration.getDestDir());
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
        }
        this.copyFolder(configuration.getSrcDir(), new File(configuration.getDestDir(), "original-src"), this.getJavaScriptFilter(), true);
        if (configuration.isIncludeUnloadedJS()) {
            this.jsonDataSaver.saveJSONData(configuration.getDestDir(), "{}", this.unloadJSData, this.uriFileTranslator);
        }
    }

    FilenameFilter getJavaScriptFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                return file.isDirectory() || name.endsWith(".js");
            }
        };
    }

    void copyFolder(File src, File dest) {
        FilenameFilter acceptAll = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        };
        this.copyFolder(src, dest, acceptAll, false);
    }

    void copyFolder(final File src, final File dest, FilenameFilter filter, boolean isReportSrc) {
        final String path = this.ioUtils.getRelativePath(src, this.configuration.getSrcDir());
        if (this.configuration.exclude(path)) {
            return;
        }
        if (src.isDirectory()) {
            for (String file : src.list(filter)) {
                this.copyFolder(new File(src, file), new File(dest, file), filter, isReportSrc);
            }
        } else if (!isReportSrc && src.toString().endsWith(".js") && !this.configuration.skipInstrumentation(path)) {
            if (!dest.getParentFile().exists()) {
                dest.getParentFile().mkdirs();
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    FileSystemInstrumenter.this.instrumenterService.instrumentJSForFileSystem(FileSystemInstrumenter.this.configuration, src, dest, path);
                    if (FileSystemInstrumenter.this.configuration.isIncludeUnloadedJS()) {
                        FileSystemInstrumenter.this.unloadedSourceProcessor.getEmptyCoverageData(FileSystemInstrumenter.this.unloadJSData, src);
                    }
                }
            });
        } else if (!isReportSrc || !this.configuration.skipInstrumentation(path)) {
            this.ioUtils.copy(src, dest);
        }
    }
}

