/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.WhileLoop;

class BranchHelper {
    private static BranchHelper branchHelper = new BranchHelper();

    BranchHelper() {
    }

    static BranchHelper getInstance() {
        return branchHelper;
    }

    boolean isBoolean(AstNode node) {
        if (node instanceof EmptyExpression) {
            return false;
        }
        switch (node.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 46: 
            case 47: 
            case 104: 
            case 105: {
                return true;
            }
        }
        if (node.getParent() instanceof IfStatement) {
            return ((IfStatement)node.getParent()).getCondition() == node;
        }
        if (node.getParent() instanceof ConditionalExpression) {
            return ((ConditionalExpression)node.getParent()).getTestExpression() == node;
        }
        if (node.getParent() instanceof WhileLoop) {
            return ((WhileLoop)node.getParent()).getCondition() == node;
        }
        if (node.getParent() instanceof DoLoop) {
            return ((DoLoop)node.getParent()).getCondition() == node;
        }
        if (node.getParent() instanceof ForLoop) {
            return ((ForLoop)node.getParent()).getCondition() == node;
        }
        return false;
    }

    public boolean isCoalesce(AstNode node) {
        return node.getType() == 104 && (node.getParent().getType() == 90 || node.getParent().getType() == 122 || node.getParent().getType() == 4);
    }
}

