/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.instrument.BranchHelper;
import jscover.instrument.BranchStatementBuilder;
import jscover.instrument.CommentsVisitor;
import jscover.instrument.PostProcess;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;

public class BranchInstrumentor
implements NodeVisitor {
    private static final String initBranchLine = "  _$jscoverage['%s'].branchData['%d'] = [];\n";
    private static final String initBranchCondition = "  _$jscoverage['%s'].branchData['%d'][%d] = new BranchData();\n";
    private static final Logger logger = Logger.getLogger(BranchInstrumentor.class.getName());
    private static int functionId = 1;
    private BranchStatementBuilder branchStatementBuilder = new BranchStatementBuilder();
    private BranchHelper branchHelper = BranchHelper.getInstance();
    private Set<PostProcess> postProcesses = new HashSet<PostProcess>();
    private String uri;
    private boolean detectCoalesce;
    private CommentsVisitor commentsVisitor;
    private AstRoot astRoot;
    private SortedMap<Integer, SortedSet<Integer>> lineConditionMap = new TreeMap<Integer, SortedSet<Integer>>();

    public BranchInstrumentor(String uri, boolean detectCoalesce, CommentsVisitor commentsVisitor) {
        this.uri = uri;
        this.detectCoalesce = detectCoalesce;
        this.commentsVisitor = commentsVisitor;
    }

    public SortedMap<Integer, SortedSet<Integer>> getLineConditionMap() {
        return this.lineConditionMap;
    }

    public void setAstRoot(AstRoot astRoot) {
        this.astRoot = astRoot;
    }

    public void postProcess() {
        for (PostProcess postProcess : this.postProcesses) {
            postProcess.process();
        }
    }

    private void replaceWithFunction(AstNode node) {
        AstNode parent = node.getParent();
        Integer conditionId = 1;
        TreeSet<Integer> conditions = (TreeSet<Integer>)this.lineConditionMap.get(node.getLineno());
        if (conditions == null) {
            conditions = new TreeSet<Integer>();
            this.lineConditionMap.put(node.getLineno(), conditions);
        } else {
            conditionId = (Integer)conditions.last() + 1;
        }
        conditions.add(conditionId);
        FunctionNode functionNode = this.branchStatementBuilder.buildBranchRecordingFunction(this.uri, functionId++, node.getLineno(), conditionId);
        this.astRoot.addChildrenToFront((Node)functionNode);
        ExpressionStatement conditionArrayDeclaration = this.branchStatementBuilder.buildLineAndConditionInitialisation(this.uri, node.getLineno(), conditionId, this.getLinePosition(node), node.getLength(), node.toSource());
        this.astRoot.addChildrenToFront((Node)conditionArrayDeclaration);
        FunctionCall functionCall = new FunctionCall();
        ArrayList<Object> arguments = new ArrayList<Object>();
        functionCall.setTarget((AstNode)functionNode.getFunctionName());
        if (node.getType() == 89) {
            ParenthesizedExpression parenthesizedExpression = new ParenthesizedExpression();
            parenthesizedExpression.setExpression(node);
            arguments.add(parenthesizedExpression);
        } else {
            arguments.add(node);
        }
        functionCall.setArguments(arguments);
        if (parent instanceof IfStatement && node == ((IfStatement)parent).getCondition()) {
            ((IfStatement)parent).setCondition((AstNode)functionCall);
        } else if (parent instanceof ParenthesizedExpression) {
            ((ParenthesizedExpression)parent).setExpression((AstNode)functionCall);
        } else if (parent instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)parent;
            if (infixExpression.getLeft() == node) {
                infixExpression.setLeft((AstNode)functionCall);
            } else {
                infixExpression.setRight((AstNode)functionCall);
            }
        } else if (parent instanceof ReturnStatement) {
            ((ReturnStatement)parent).setReturnValue((AstNode)functionCall);
        } else if (parent instanceof VariableInitializer) {
            ((VariableInitializer)parent).setInitializer((AstNode)functionCall);
        } else if (parent instanceof SwitchStatement) {
            ((SwitchStatement)parent).setExpression((AstNode)functionCall);
        } else if (parent instanceof WhileLoop) {
            ((WhileLoop)parent).setCondition((AstNode)functionCall);
        } else if (parent instanceof DoLoop) {
            ((DoLoop)parent).setCondition((AstNode)functionCall);
        } else if (parent instanceof ForLoop) {
            ((ForLoop)parent).setCondition((AstNode)functionCall);
        } else if (parent instanceof ElementGet) {
            ((ElementGet)parent).setElement((AstNode)functionCall);
        } else if (parent instanceof ExpressionStatement) {
            ((ExpressionStatement)parent).setExpression((AstNode)functionCall);
        } else if (parent instanceof ConditionalExpression) {
            ConditionalExpression ternary = (ConditionalExpression)parent;
            if (ternary.getTestExpression() == node) {
                ternary.setTestExpression((AstNode)functionCall);
            } else if (ternary.getTrueExpression() == node) {
                ternary.setTrueExpression((AstNode)functionCall);
            } else {
                ternary.setFalseExpression((AstNode)functionCall);
            }
        } else if (parent instanceof ArrayLiteral) {
            this.postProcesses.add(new PostProcess(parent, node, functionCall){

                @Override
                void run(AstNode parent, AstNode node, AstNode functionCall) {
                    ArrayLiteral arrayParent = (ArrayLiteral)parent;
                    List elements = arrayParent.getElements();
                    ArrayList<AstNode> newElements = new ArrayList<AstNode>();
                    for (AstNode element : elements) {
                        if (element == node) {
                            newElements.add(functionCall);
                            continue;
                        }
                        newElements.add(element);
                    }
                    arrayParent.setElements(newElements);
                }
            });
        } else if (parent instanceof FunctionCall) {
            this.postProcesses.add(new PostProcess(parent, node, functionCall){

                @Override
                void run(AstNode parent, AstNode node, AstNode functionCall) {
                    FunctionCall fnParent = (FunctionCall)parent;
                    List fnParentArguments = fnParent.getArguments();
                    ArrayList<AstNode> newFnParentArguments = new ArrayList<AstNode>();
                    for (AstNode arg : fnParentArguments) {
                        if (arg == node) {
                            newFnParentArguments.add(functionCall);
                            continue;
                        }
                        newFnParentArguments.add(arg);
                    }
                    fnParent.setArguments(newFnParentArguments);
                }
            });
        } else {
            logger.log(Level.SEVERE, String.format("Couldn't insert wrapper for parent %s, file: %s, line: %d, position: %d, source: %s", parent.getClass().getName(), this.uri, node.getLineno(), node.getPosition(), node.toSource()));
        }
    }

    public boolean visit(AstNode node) {
        if (!(node.getLineno() <= 0 || this.commentsVisitor.ignoreBranch(node.getLineno()) || !this.branchHelper.isBoolean(node) || this.detectCoalesce && this.branchHelper.isCoalesce(node))) {
            this.replaceWithFunction(node);
        }
        return true;
    }

    public int getLinePosition(AstNode node) {
        int pos = node.getPosition();
        for (AstNode parent = node.getParent(); parent != null && parent.getLineno() == node.getLineno(); parent = parent.getParent()) {
            pos += parent.getPosition();
        }
        return pos - 1;
    }

    protected String getJsLineInitialization() {
        String fileName = this.uri.replace("\\", "\\\\").replace("'", "\\'");
        StringBuilder sb = new StringBuilder(String.format("if (! _$jscoverage['%s'].branchData) {\n", fileName));
        sb.append(String.format("  _$jscoverage['%s'].branchData = {};\n", fileName));
        for (Integer line : this.lineConditionMap.keySet()) {
            sb.append(String.format(initBranchLine, fileName, line));
            for (Integer condition : (SortedSet)this.lineConditionMap.get(line)) {
                sb.append(String.format(initBranchCondition, fileName, line, condition));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }
}

