/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.ArrayList;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.StringLiteral;

public class BranchStatementBuilder {
    public ExpressionStatement buildLineAndConditionInitialisation(String uri, int lineNo, int conditionNo, int position, int length, String source) {
        ElementGet indexLineNumber = this.buildLineDeclaration(uri, lineNo);
        NumberLiteral conditionNumberLiteral = new NumberLiteral();
        conditionNumberLiteral.setValue("" + conditionNo);
        ElementGet indexConditionNumber = new ElementGet((AstNode)indexLineNumber, (AstNode)conditionNumberLiteral);
        FunctionCall fnCall = new FunctionCall();
        Name propertyName = new Name();
        propertyName.setIdentifier("init");
        PropertyGet propertyGet = new PropertyGet((AstNode)indexConditionNumber, propertyName);
        fnCall.setTarget((AstNode)propertyGet);
        NumberLiteral positionLiteral = new NumberLiteral();
        positionLiteral.setValue("" + position);
        fnCall.addArgument((AstNode)positionLiteral);
        NumberLiteral lengthLiteral = new NumberLiteral();
        lengthLiteral.setValue("" + length);
        fnCall.addArgument((AstNode)lengthLiteral);
        StringLiteral stringLiteral = new StringLiteral();
        stringLiteral.setValue(this.removeInstrumentation(source));
        stringLiteral.setQuoteCharacter('\'');
        fnCall.addArgument((AstNode)stringLiteral);
        return new ExpressionStatement((AstNode)fnCall);
    }

    protected String removeInstrumentation(String source) {
        return source.replaceAll(" *_\\$jscoverage\\['[^']+'\\]\\.[^\\[]+\\[\\d+\\]\\+\\+;\n", "");
    }

    public ExpressionStatement buildLineAndConditionCall(String uri, int lineNo, int conditionNo) {
        ElementGet indexLineNumber = this.buildLineDeclaration(uri, lineNo);
        NumberLiteral conditionNumberLiteral = new NumberLiteral();
        conditionNumberLiteral.setValue("" + conditionNo);
        ElementGet indexConditionNumber = new ElementGet((AstNode)indexLineNumber, (AstNode)conditionNumberLiteral);
        Name resultName = new Name();
        resultName.setIdentifier("result");
        FunctionCall fnCall = new FunctionCall();
        Name propertyName = new Name();
        propertyName.setIdentifier("ranCondition");
        PropertyGet propertyGet = new PropertyGet((AstNode)indexConditionNumber, propertyName);
        fnCall.setTarget((AstNode)propertyGet);
        ArrayList<Name> arguments = new ArrayList<Name>();
        arguments.add(resultName);
        fnCall.setArguments(arguments);
        return new ExpressionStatement((AstNode)fnCall);
    }

    private ElementGet buildLineDeclaration(String uri, int lineNo) {
        Name jscoverageVar = new Name();
        jscoverageVar.setIdentifier("_$jscoverage");
        StringLiteral fileNameLiteral = new StringLiteral();
        fileNameLiteral.setValue(uri);
        fileNameLiteral.setQuoteCharacter('\'');
        ElementGet indexJSFile = new ElementGet((AstNode)jscoverageVar, (AstNode)fileNameLiteral);
        Name branchPropertyName = new Name();
        branchPropertyName.setIdentifier("branchData");
        PropertyGet branchProperty = new PropertyGet((AstNode)indexJSFile, branchPropertyName);
        NumberLiteral lineNumberLiteral = new NumberLiteral();
        lineNumberLiteral.setValue("'" + lineNo + "'");
        return new ElementGet((AstNode)branchProperty, (AstNode)lineNumberLiteral);
    }

    public FunctionNode buildBranchRecordingFunction(String uri, int id, int lineNo, int conditionNo) {
        Name functionName = new Name();
        functionName.setIdentifier(String.format("visit%d_%d_%d", id, lineNo, conditionNo));
        FunctionNode functionNode = new FunctionNode();
        functionNode.setFunctionName(functionName);
        Name resultName = new Name();
        resultName.setIdentifier("result");
        functionNode.addParam((AstNode)resultName);
        Block block = new Block();
        block.addStatement((AstNode)this.buildLineAndConditionCall(uri, lineNo, conditionNo));
        ReturnStatement returnStatement = new ReturnStatement();
        returnStatement.setReturnValue((AstNode)resultName);
        block.addChild((AstNode)returnStatement);
        functionNode.setBody((AstNode)block);
        return functionNode;
    }
}

