/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jscover.instrument.CommentRange;
import jscover.instrument.JSCoverageIgnoreComment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.NodeVisitor;

public class CommentsVisitor
implements NodeVisitor {
    static final String EXCL_LINE = "//#JSCOVER_EXCL_LINE";
    static final String EXCL_START = "//#JSCOVER_EXCL_START";
    static final String EXCL_STOP = "//#JSCOVER_EXCL_STOP";
    static final String EXCL_BR_LINE = "//#JSCOVER_EXCL_BR_LINE";
    static final String EXCL_BR_START = "//#JSCOVER_EXCL_BR_START";
    static final String EXCL_BR_STOP = "//#JSCOVER_EXCL_BR_STOP";
    private Set<Integer> ignoreLines = new HashSet<Integer>();
    private LinkedList<CommentRange> ignoreLineRanges = new LinkedList();
    private Set<Integer> ignoreBranches = new HashSet<Integer>();
    private LinkedList<CommentRange> ignoreBranchRanges = new LinkedList();
    private LinkedList<JSCoverageIgnoreComment> jsCoverageIgnoreComments = new LinkedList();

    public List<JSCoverageIgnoreComment> getJsCoverageIgnoreComments() {
        return this.jsCoverageIgnoreComments;
    }

    public boolean visit(AstNode node) {
        if (node instanceof Comment) {
            String comment = ((Comment)node).getValue();
            if (this.rhinoSafeStartsWith(comment, "//#JSCOVERAGE_IF")) {
                if (comment.trim().length() > "//#JSCOVERAGE_IF".length()) {
                    this.jsCoverageIgnoreComments.add(new JSCoverageIgnoreComment(comment.substring("//#JSCOVERAGE_IF".length() + 1), node.getLineno()));
                }
            } else if (this.rhinoSafeStartsWith(comment, EXCL_LINE)) {
                this.ignoreLines.add(node.getLineno());
            } else if (this.rhinoSafeStartsWith(comment, EXCL_START)) {
                this.ignoreLineRanges.add(new CommentRange(node.getLineno()));
            } else if (this.rhinoSafeStartsWith(comment, EXCL_STOP)) {
                this.ignoreLineRanges.getLast().setEnd(node.getLineno());
            } else if (this.rhinoSafeStartsWith(comment, EXCL_BR_LINE)) {
                this.ignoreBranches.add(node.getLineno());
            } else if (this.rhinoSafeStartsWith(comment, EXCL_BR_START)) {
                this.ignoreBranchRanges.add(new CommentRange(node.getLineno()));
            } else if (this.rhinoSafeStartsWith(comment, EXCL_BR_STOP)) {
                this.ignoreBranchRanges.getLast().setEnd(node.getLineno());
            } else if (this.rhinoSafeStartsWith(comment, "//#JSCOVERAGE_ENDIF")) {
                this.jsCoverageIgnoreComments.getLast().setEnd(node.getLineno());
            }
            return true;
        }
        return true;
    }

    private boolean rhinoSafeStartsWith(String comment, String ignoreEnd) {
        return comment.startsWith(ignoreEnd.substring(0, ignoreEnd.length() - 1));
    }

    public boolean ignoreLine(int line) {
        if (this.ignoreLines.contains(line)) {
            return true;
        }
        for (CommentRange range : this.ignoreLineRanges) {
            if (!range.inRange(line)) continue;
            return true;
        }
        return false;
    }

    public boolean ignoreBranch(int line) {
        if (this.ignoreBranches.contains(line)) {
            return true;
        }
        for (CommentRange range : this.ignoreBranchRanges) {
            if (!range.inRange(line)) continue;
            return true;
        }
        return false;
    }
}

