/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.ConfigurationCommon;
import jscover.instrument.SourceProcessor;
import jscover.server.UriNotFound;
import jscover.util.IoUtils;

public class InstrumenterService {
    private static final Logger logger = Logger.getLogger(InstrumenterService.class.getName());
    private IoUtils ioUtils = IoUtils.getInstance();

    public String instrumentJSForWebServer(ConfigurationCommon config, File srcFile, String uri) {
        logger.log(Level.INFO, "Instrumenting {0}", uri);
        SourceProcessor sourceProcessor = new SourceProcessor(config, uri);
        try {
            String source = this.ioUtils.toString(new FileInputStream(srcFile));
            return sourceProcessor.processSourceForServer(source);
        }
        catch (FileNotFoundException e) {
            throw new UriNotFound("Couldn't find " + uri, e);
        }
    }

    public String instrumentJSForProxyServer(ConfigurationCommon config, String source, String uri) {
        logger.log(Level.INFO, "Instrumenting {0}", uri);
        SourceProcessor sourceProcessor = new SourceProcessor(config, uri);
        return sourceProcessor.processSourceForServer(source);
    }

    public void instrumentJSForFileSystem(ConfigurationCommon config, File srcFile, File dest, String uri) {
        logger.log(Level.INFO, "Instrumenting {0}", uri);
        SourceProcessor sourceProcessor = new SourceProcessor(config, "/" + uri);
        String source = this.ioUtils.loadFromFileSystem(srcFile);
        String jsInstrumented = sourceProcessor.processSourceForFileSystem(source);
        this.ioUtils.copy(jsInstrumented, dest);
    }
}

