/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import jscover.instrument.CommentsVisitor;
import jscover.instrument.StatementBuilder;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.EmptyStatement;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.LetNode;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WithStatement;

class NodeProcessor {
    private StatementBuilder statementBuilder = new StatementBuilder();
    private SortedSet<Integer> validLines = new TreeSet<Integer>();
    private int functionNumber;
    private String fileName;
    private boolean includeFunctionCoverage;
    private CommentsVisitor commentsVisitor;

    public NodeProcessor(String uri, boolean includeFunctionCoverage, CommentsVisitor commentsVisitor) {
        this.fileName = uri;
        this.includeFunctionCoverage = includeFunctionCoverage;
        this.commentsVisitor = commentsVisitor;
    }

    public ExpressionStatement buildInstrumentationStatement(int lineNumber) {
        return this.statementBuilder.buildInstrumentationStatement(lineNumber, this.fileName, this.validLines);
    }

    public ExpressionStatement buildFunctionInstrumentationStatement(int functionNumber) {
        return this.statementBuilder.buildFunctionInstrumentationStatement(functionNumber, this.fileName);
    }

    boolean processNode(AstNode node) {
        AstNode parent;
        AstNode block;
        if (this.includeFunctionCoverage && node instanceof FunctionNode && (block = ((FunctionNode)node).getBody()) instanceof Block) {
            block.addChildToFront((Node)this.buildFunctionInstrumentationStatement(this.functionNumber++));
        }
        if (node instanceof SwitchCase) {
            return this.processSwitchCase(node, (SwitchCase)node);
        }
        if (this.validLines.contains(node.getLineno()) || this.commentsVisitor.ignoreLine(node.getLineno())) {
            return true;
        }
        if (node.getParent() == null || node.getLineno() == node.getParent().getLineno()) {
            // empty if block
        }
        if ((parent = node.getParent()) instanceof ObjectProperty || parent instanceof FunctionCall) {
            return true;
        }
        if (node instanceof ExpressionStatement || node instanceof EmptyExpression || node instanceof Loop || node instanceof ContinueStatement || node instanceof VariableDeclaration || node instanceof LetNode || node instanceof SwitchStatement || node instanceof BreakStatement || node instanceof EmptyStatement || node instanceof ThrowStatement) {
            if (node.getLineno() < 1) {
                return true;
            }
            if (!(parent instanceof SwitchCase || parent instanceof LabeledStatement || this.isLoopInitializer(node) || parent == null)) {
                this.addInstrumentationBefore(node);
            }
        } else if (node instanceof WithStatement) {
            this.addInstrumentationBefore(node);
        } else if (node instanceof FunctionNode || node instanceof TryStatement || this.isDebugStatement(node)) {
            if (!(parent instanceof InfixExpression || parent instanceof VariableInitializer || parent instanceof ConditionalExpression || parent instanceof ArrayLiteral || parent instanceof ParenthesizedExpression)) {
                this.addInstrumentationBefore(node);
            }
        } else if (node instanceof ReturnStatement) {
            this.addInstrumentationBefore(node);
        } else if (node instanceof LabeledStatement) {
            LabeledStatement labeledStatement = (LabeledStatement)node;
            ExpressionStatement newChild = this.buildInstrumentationStatement(labeledStatement.getLineno());
            parent.addChildBefore((Node)newChild, (Node)node);
        } else if (node instanceof IfStatement) {
            this.addInstrumentationBefore(node);
        }
        return true;
    }

    private boolean processSwitchCase(AstNode node, SwitchCase switchCase) {
        ArrayList<ExpressionStatement> statements = switchCase.getStatements();
        if (statements == null) {
            statements = new ArrayList<ExpressionStatement>();
            statements.add(this.buildInstrumentationStatement(node.getLineno()));
            switchCase.setStatements(statements);
            return true;
        }
        boolean changed = false;
        for (int i = statements.size() - 1; i >= 0; --i) {
            AstNode statement = (AstNode)statements.get(i);
            if (this.validLines.contains(statement.getLineno())) continue;
            statements.add(i, this.buildInstrumentationStatement(statement.getLineno()));
            changed = true;
        }
        return changed;
    }

    private boolean isLoopInitializer(AstNode node) {
        ForLoop forLoop;
        return node.getParent() instanceof ForLoop && (forLoop = (ForLoop)node.getParent()).getInitializer() == node;
    }

    private void addInstrumentationBefore(AstNode node) {
        AstNode parent = node.getParent();
        if (parent instanceof IfStatement) {
            this.addIfScope(node, (IfStatement)parent);
        } else if (parent instanceof Loop) {
            this.addLoopScope(node, (Loop)parent);
        } else if (parent instanceof WithStatement) {
            this.addWithScope(node, (WithStatement)parent);
        } else {
            parent.addChildBefore((Node)this.buildInstrumentationStatement(node.getLineno()), (Node)node);
        }
    }

    private Scope makeReplacementScope(AstNode node) {
        Scope scope = new Scope();
        scope.addChild((AstNode)this.buildInstrumentationStatement(node.getLineno()));
        scope.addChild(node);
        return scope;
    }

    private void addWithScope(AstNode node, WithStatement with) {
        Scope scope = this.makeReplacementScope(node);
        with.setStatement((AstNode)scope);
    }

    private void addLoopScope(AstNode node, Loop parentLoop) {
        Scope scope = this.makeReplacementScope(node);
        parentLoop.setBody((AstNode)scope);
    }

    private void addIfScope(AstNode node, IfStatement parentIf) {
        Scope scope = this.makeReplacementScope(node);
        if (parentIf.getThenPart() == node) {
            parentIf.setThenPart((AstNode)scope);
        } else if (parentIf.getElsePart() == node) {
            parentIf.setElsePart((AstNode)scope);
        }
    }

    private boolean isDebugStatement(AstNode node) {
        if (!(node instanceof KeywordLiteral)) {
            return false;
        }
        KeywordLiteral keywordLiteral = (KeywordLiteral)node;
        return keywordLiteral.getType() == 160;
    }

    public SortedSet<Integer> getValidLines() {
        return this.validLines;
    }

    public int getNumFunctions() {
        return this.functionNumber;
    }
}

