/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.List;
import java.util.SortedSet;
import jscover.ConfigurationCommon;
import jscover.instrument.BranchInstrumentor;
import jscover.instrument.CommentsVisitor;
import jscover.instrument.JSCoverageIgnoreComment;
import jscover.instrument.ParseTreeInstrumenter;
import jscover.util.IoUtils;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.NodeVisitor;

class SourceProcessor {
    private static final String initLine = "  _$jscoverage['%s'].lineData[%d] = 0;\n";
    private static final String initFunction = "  _$jscoverage['%s'].functionData[%d] = 0;\n";
    private static final String ignoreJS = "\nif (!(%s)) {\n  _$jscoverage['%s'].conditionals[%d] = %d;\n}";
    private String uri;
    private CommentsVisitor commentsVisitor = new CommentsVisitor();
    private ParseTreeInstrumenter instrumenter;
    private BranchInstrumentor branchInstrumentor;
    private Parser parser;
    private IoUtils ioUtils = IoUtils.getInstance();
    private boolean includeBranchCoverage;
    private boolean includeFunctionCoverage;
    private boolean localStorage;
    private boolean isolateBrowser;

    public SourceProcessor(ConfigurationCommon config, String uri) {
        this.uri = uri;
        this.instrumenter = new ParseTreeInstrumenter(uri, config.isIncludeFunction(), this.commentsVisitor);
        this.branchInstrumentor = new BranchInstrumentor(uri, config.isDetectCoalesce(), this.commentsVisitor);
        this.parser = new Parser(config.getCompilerEnvirons());
        this.includeBranchCoverage = config.isIncludeBranch();
        this.includeFunctionCoverage = config.isIncludeFunction();
        this.localStorage = config.isLocalStorage();
        this.isolateBrowser = config.isolateBrowser();
    }

    ParseTreeInstrumenter getInstrumenter() {
        return this.instrumenter;
    }

    BranchInstrumentor getBranchInstrumentor() {
        return this.branchInstrumentor;
    }

    public String processSourceForServer(String source) {
        String reportJS = this.ioUtils.loadFromClassPath("/report.js");
        return reportJS + this.processSource(this.uri, source);
    }

    public String processSourceForFileSystem(String source) {
        return this.processSource(this.uri, source);
    }

    protected String processSource(String sourceURI, String source) {
        String headerJS = this.getIsolateBrowserJS() + this.ioUtils.loadFromClassPath("/header.js");
        String localStorageJS = this.localStorage ? this.ioUtils.loadFromClassPath("/jscoverage-localstorage.js") : "";
        String commonJS = this.ioUtils.loadFromClassPath("/jscoverage-common.js");
        String branchJS = this.ioUtils.loadFromClassPath("/jscoverage-branch.js");
        return branchJS + commonJS + localStorageJS + headerJS + this.processSourceWithoutHeader(sourceURI, source);
    }

    private String getIsolateBrowserJS() {
        return "var jsCover_isolateBrowser = " + (this.isolateBrowser ? "true" : "false") + ";\n";
    }

    protected String processSourceWithoutHeader(String source) {
        return this.processSourceWithoutHeader(this.uri, source);
    }

    protected String processSourceWithoutHeader(String sourceURI, String source) {
        String instrumentedSource = this.instrumentSource(sourceURI, source);
        String jsLineInitialization = this.getJsLineInitialization(this.uri, this.instrumenter.getValidLines());
        if (this.commentsVisitor.getJsCoverageIgnoreComments().size() > 0) {
            jsLineInitialization = jsLineInitialization + String.format("_$jscoverage['%s'].conditionals = [];\n", this.uri);
        }
        if (this.includeFunctionCoverage) {
            jsLineInitialization = jsLineInitialization + this.getJsFunctionInitialization(this.uri, this.instrumenter.getNumFunctions());
        }
        if (this.includeBranchCoverage) {
            jsLineInitialization = jsLineInitialization + this.branchInstrumentor.getJsLineInitialization();
        }
        String jsConditionals = this.getJsConditionals(this.uri, this.commentsVisitor.getJsCoverageIgnoreComments());
        return jsLineInitialization + instrumentedSource + jsConditionals;
    }

    protected String instrumentSource(String source) {
        return this.instrumentSource(this.uri, source);
    }

    protected String instrumentSource(String sourceURI, String source) {
        AstRoot astRoot = this.parser.parse(source, sourceURI, 1);
        astRoot.visitComments((NodeVisitor)this.commentsVisitor);
        astRoot.visit((NodeVisitor)this.instrumenter);
        if (this.includeBranchCoverage) {
            this.branchInstrumentor.setAstRoot(astRoot);
            astRoot.visit((NodeVisitor)this.branchInstrumentor);
            this.branchInstrumentor.postProcess();
        }
        return astRoot.toSource();
    }

    protected String getJsLineInitialization(String fileName, SortedSet<Integer> validLines) {
        fileName = fileName.replace("\\", "\\\\").replace("'", "\\'");
        StringBuilder sb = new StringBuilder(String.format("if (! _$jscoverage['%s']) {\n", fileName));
        sb.append(String.format("  _$jscoverage['%s'] = {};\n", fileName));
        sb.append(String.format("  _$jscoverage['%s'].lineData = [];\n", fileName));
        for (Integer line : validLines) {
            sb.append(String.format(initLine, fileName, line));
        }
        sb.append("}\n");
        return sb.toString();
    }

    protected String getJsFunctionInitialization(String fileName, int numFunction) {
        fileName = fileName.replace("\\", "\\\\").replace("'", "\\'");
        StringBuilder sb = new StringBuilder(String.format("if (! _$jscoverage['%s'].functionData) {\n", fileName));
        sb.append(String.format("  _$jscoverage['%s'].functionData = [];\n", fileName));
        for (int i = 0; i < numFunction; ++i) {
            sb.append(String.format(initFunction, fileName, i));
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String getJsConditionals(String fileName, List<JSCoverageIgnoreComment> ignores) {
        fileName = fileName.replace("\\", "\\\\").replace("'", "\\'");
        StringBuilder sb = new StringBuilder();
        for (JSCoverageIgnoreComment ignore : ignores) {
            sb.append(String.format(ignoreJS, ignore.getCondition(), fileName, ignore.getStart(), ignore.getEnd()));
        }
        return sb.toString();
    }
}

