/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.SortedSet;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.UnaryExpression;

class StatementBuilder {
    StatementBuilder() {
    }

    public ExpressionStatement buildInstrumentationStatement(int lineNumber, String fileName, SortedSet<Integer> validLines) {
        if (lineNumber < 1) {
            throw new IllegalStateException("Illegal line number: " + lineNumber);
        }
        validLines.add(lineNumber);
        return this.buildInstrumentationIncrementer(lineNumber, fileName, "lineData");
    }

    public ExpressionStatement buildFunctionInstrumentationStatement(int lineNumber, String fileName) {
        return this.buildInstrumentationIncrementer(lineNumber, fileName, "functionData");
    }

    public ExpressionStatement buildConditionalStatement(int startLine, int endLine, String fileName) {
        ElementGet indexLineNumber = this.buildLineNumberExpression(startLine, fileName, "conditionals");
        NumberLiteral lineNumberLiteral = new NumberLiteral();
        lineNumberLiteral.setValue("" + endLine);
        Assignment assignment = new Assignment(90, (AstNode)indexLineNumber, (AstNode)lineNumberLiteral, 0);
        return new ExpressionStatement((AstNode)assignment);
    }

    private ExpressionStatement buildInstrumentationIncrementer(int lineNumber, String fileName, String identifier) {
        ElementGet indexLineNumber = this.buildLineNumberExpression(lineNumber, fileName, identifier);
        UnaryExpression unaryExpression = new UnaryExpression(106, 0, (AstNode)indexLineNumber, true);
        return new ExpressionStatement((AstNode)unaryExpression);
    }

    private ElementGet buildLineNumberExpression(int lineNumber, String fileName, String identifier) {
        Name var = new Name(0, "_$jscoverage");
        StringLiteral fileNameLiteral = new StringLiteral();
        fileNameLiteral.setValue(fileName);
        fileNameLiteral.setQuoteCharacter('\'');
        ElementGet indexJSFile = new ElementGet((AstNode)var, (AstNode)fileNameLiteral);
        Name propertyName = new Name();
        propertyName.setIdentifier(identifier);
        PropertyGet lineProperty = new PropertyGet((AstNode)indexJSFile, propertyName);
        NumberLiteral lineNumberLiteral = new NumberLiteral();
        lineNumberLiteral.setValue("" + lineNumber);
        return new ElementGet((AstNode)lineProperty, (AstNode)lineNumberLiteral);
    }
}

