/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.ConfigurationCommon;
import jscover.instrument.SourceProcessor;
import jscover.report.ScriptCoverageCount;
import jscover.util.FileScanner;
import jscover.util.IoUtils;

public class UnloadedSourceProcessor {
    private static final Logger logger = Logger.getLogger(UnloadedSourceProcessor.class.getName());
    private ConfigurationCommon config;
    private IoUtils ioUtils = IoUtils.getInstance();
    private FileScanner fileScanner;
    private File scanPath;

    public UnloadedSourceProcessor(ConfigurationCommon config, File scanPath) {
        this.scanPath = scanPath;
        this.fileScanner = new FileScanner(config, scanPath);
        this.config = config;
    }

    public List<ScriptCoverageCount> getEmptyCoverageData(Set<String> urisAlreadyProcessed) {
        ArrayList<ScriptCoverageCount> scripts = new ArrayList<ScriptCoverageCount>();
        for (File file : this.fileScanner.getFiles(urisAlreadyProcessed)) {
            this.getEmptyCoverageData(scripts, file);
        }
        return scripts;
    }

    public void getEmptyCoverageData(List<ScriptCoverageCount> scripts, File file) {
        String uri = this.ioUtils.getRelativePath(file, this.scanPath);
        SourceProcessor sourceProcessor = new SourceProcessor(this.config, uri);
        try {
            sourceProcessor.instrumentSource(this.ioUtils.loadFromFileSystem(file));
            ScriptCoverageCount script = new ScriptCoverageCount("/" + uri, new ArrayList<Integer>(sourceProcessor.getInstrumenter().getValidLines()), sourceProcessor.getInstrumenter().getNumFunctions(), sourceProcessor.getBranchInstrumentor().getLineConditionMap());
            scripts.add(script);
        }
        catch (RuntimeException t) {
            logger.log(Level.SEVERE, String.format("Problem parsing %s", uri), t);
        }
    }
}

