/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.report.BranchData;
import jscover.report.FileData;
import jscover.report.ScriptCoverageCount;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.json.JsonParser;

public class JSONDataMerger {
    private static final Logger logger = Logger.getLogger(FileData.class.getName());
    public static final String NO_CONDITIONS_ARE_COVERED = "No conditions are covered";
    private Context cx = Context.enter();
    private JsonParser parser = new JsonParser(this.cx, (Scriptable)this.cx.initStandardObjects());

    public SortedMap<String, FileData> mergeJSONCoverageStrings(String ... data) {
        TreeMap<String, FileData> total = new TreeMap<String, FileData>();
        for (String json : data) {
            this.mergeJSONCoverageMaps(total, this.jsonToMap(json));
        }
        return total;
    }

    public SortedMap<String, FileData> mergeJSONCoverageMaps(SortedMap<String, FileData> map1, SortedMap<String, FileData> map2) {
        for (String scriptName : map1.keySet()) {
            int i;
            logger.log(Level.FINE, "Processing {0}", scriptName);
            if (!map2.containsKey(scriptName)) continue;
            FileData coverageData = (FileData)map1.get(scriptName);
            for (i = 0; i < coverageData.getLines().size(); ++i) {
                if (coverageData.getLines().get(i) == null) continue;
                logger.log(Level.FINEST, "Add line coverage from {0} line {1}", new Object[]{scriptName, i});
                coverageData.addCoverage(((FileData)map2.get(scriptName)).getLines().get(i), i);
            }
            for (i = 0; i < coverageData.getFunctions().size(); ++i) {
                logger.log(Level.FINEST, "Add function coverage from {0} function number {1}", new Object[]{scriptName, i + 1});
                coverageData.addFunctionCoverage(((FileData)map2.get(scriptName)).getFunctions().get(i), i);
            }
            for (int i2 : coverageData.getBranchData().keySet()) {
                List conditions = (List)coverageData.getBranchData().get(i2);
                for (int j = 0; j < conditions.size(); ++j) {
                    if (conditions.get(j) == null) continue;
                    logger.log(Level.FINEST, "Add branch coverage from {0} line {1} condition {2}", new Object[]{scriptName, i2 + 1, j});
                    ((BranchData)conditions.get(j)).addCoverage((BranchData)((List)((FileData)map2.get(scriptName)).getBranchData().get(i2)).get(j));
                }
            }
        }
        for (String scriptName : map2.keySet()) {
            if (map1.containsKey(scriptName)) continue;
            logger.log(Level.FINE, "Add script {0}", scriptName);
            map1.put(scriptName, (FileData)map2.get(scriptName));
        }
        return map1;
    }

    public SortedMap<String, FileData> jsonToMap(String data) {
        TreeMap<String, FileData> map = new TreeMap<String, FileData>();
        try {
            NativeObject json = (NativeObject)this.parser.parseValue(data);
            for (Object scriptURI : json.keySet()) {
                NativeObject scriptData = (NativeObject)json.get(scriptURI);
                NativeArray lineCoverageArray = (NativeArray)scriptData.get((Object)"lineData");
                NativeObject branchJSONArray = (NativeObject)scriptData.get((Object)"branchData");
                ArrayList<Integer> countData = new ArrayList<Integer>(lineCoverageArray.size());
                for (int i = 0; i < lineCoverageArray.size(); ++i) {
                    countData.add((Integer)lineCoverageArray.get(i));
                }
                NativeArray functionCoverageArray = (NativeArray)scriptData.get((Object)"functionData");
                ArrayList<Integer> funcData = new ArrayList<Integer>();
                if (functionCoverageArray != null) {
                    for (int i = 0; i < functionCoverageArray.size(); ++i) {
                        funcData.add((Integer)functionCoverageArray.get(i));
                    }
                }
                TreeMap<Integer, List<BranchData>> branchLineMap = new TreeMap<Integer, List<BranchData>>();
                if (branchJSONArray != null) {
                    this.readBranchLines(branchJSONArray, branchLineMap);
                }
                map.put((String)scriptURI, new FileData((String)scriptURI, countData, funcData, branchLineMap));
            }
        }
        catch (JsonParser.ParseException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private void readBranchLines(NativeObject branchJSONObject, SortedMap<Integer, List<BranchData>> branchLineMap) {
        for (Object line : branchJSONObject.keySet()) {
            ArrayList<BranchData> branchConditionArray = new ArrayList<BranchData>();
            branchLineMap.put((Integer)line, branchConditionArray);
            NativeArray conditionsJSON = (NativeArray)branchJSONObject.get(line);
            this.readBranchCondition(branchConditionArray, conditionsJSON);
        }
    }

    private void readBranchCondition(List<BranchData> branchConditionArray, NativeArray conditionsJSON) {
        for (int j = 0; j < conditionsJSON.size(); ++j) {
            NativeObject conditionJSON = (NativeObject)conditionsJSON.get(j);
            if (conditionJSON == null) {
                branchConditionArray.add(null);
                continue;
            }
            int position = (Integer)conditionJSON.get((Object)"position");
            int nodeLength = (Integer)conditionJSON.get((Object)"nodeLength");
            String src = (String)conditionJSON.get((Object)"src");
            int evalFalse = (Integer)conditionJSON.get((Object)"evalFalse");
            int evalTrue = (Integer)conditionJSON.get((Object)"evalTrue");
            branchConditionArray.add(new BranchData(position, nodeLength, src, evalFalse, evalTrue));
        }
    }

    String toJSON(SortedMap<String, FileData> map) {
        StringBuilder json = new StringBuilder("{");
        int scriptCount = 0;
        for (String scriptURI : map.keySet()) {
            StringBuilder coverage = new StringBuilder();
            StringBuilder branchData = new StringBuilder();
            FileData coverageData = (FileData)map.get(scriptURI);
            for (int i = 0; i < coverageData.getLines().size(); ++i) {
                if (i > 0) {
                    coverage.append(",");
                }
                coverage.append(coverageData.getLines().get(i));
            }
            StringBuilder functions = new StringBuilder();
            for (int i = 0; i < coverageData.getFunctions().size(); ++i) {
                if (i > 0) {
                    functions.append(",");
                }
                functions.append(coverageData.getFunctions().get(i));
            }
            this.addBranchData(branchData, coverageData);
            if (scriptCount++ > 0) {
                json.append(",");
            }
            StringBuilder scriptJSON = new StringBuilder(String.format("\"%s\":{", scriptURI));
            scriptJSON.append(String.format("\"lineData\":[%s]", coverage));
            if (functions.length() > 0) {
                scriptJSON.append(String.format(",\"functionData\":[%s]", functions));
            }
            if (branchData.length() > 0) {
                scriptJSON.append(String.format(",\"branchData\":{%s}", branchData));
            }
            scriptJSON.append("}");
            json.append((CharSequence)scriptJSON);
        }
        json.append("}");
        return json.toString();
    }

    private void addBranchData(StringBuilder branchData, FileData coverageData) {
        int count = 0;
        for (Integer i : coverageData.getBranchData().keySet()) {
            List conditions = (List)coverageData.getBranchData().get(i);
            if (count++ > 0) {
                branchData.append(",");
            }
            branchData.append(String.format("\"%s\":[", i));
            this.addBranchConditions(branchData, conditions);
            branchData.append("]");
        }
    }

    private void addBranchConditions(StringBuilder branchData, List<BranchData> conditions) {
        for (int j = 0; j < conditions.size(); ++j) {
            BranchData branchObj;
            if (j > 0) {
                branchData.append(",");
            }
            if ((branchObj = conditions.get(j)) == null) {
                branchData.append("null");
                continue;
            }
            String branchJSON = "{\"position\":%d,\"nodeLength\":%d,\"src\":\"%s\",\"evalFalse\":%d,\"evalTrue\":%d}";
            String branchSource = ScriptRuntime.escapeString((String)branchObj.getSource());
            branchData.append(String.format(branchJSON, branchObj.getPosition(), branchObj.getNodeLength(), branchSource, branchObj.getEvalFalse(), branchObj.getEvalTrue()));
        }
    }

    public SortedMap<String, FileData> createEmptyJSON(List<ScriptCoverageCount> scripts) {
        TreeMap<String, FileData> map = new TreeMap<String, FileData>();
        for (ScriptCoverageCount script : scripts) {
            List<Integer> codeLines = script.getLines();
            FileData coverageData = new FileData(script.getUri(), this.getNoHitLineData(codeLines), this.getNoHitFunctionData(script.getFunctionCount()), this.getNoHitBranchData(script.getBranchData()));
            map.put(script.getUri(), coverageData);
        }
        return map;
    }

    private List<Integer> getNoHitLineData(List<Integer> codeLines) {
        if (codeLines.size() == 0) {
            return new ArrayList<Integer>();
        }
        Integer[] lines = new Integer[codeLines.get(codeLines.size() - 1) + 1];
        for (int i = 0; i < codeLines.size(); ++i) {
            lines[codeLines.get((int)i).intValue()] = 0;
        }
        return Arrays.asList(lines);
    }

    private List<Integer> getNoHitFunctionData(int functionCount) {
        ArrayList<Integer> functionData = new ArrayList<Integer>();
        for (int i = 0; i < functionCount; ++i) {
            functionData.add(0);
        }
        return functionData;
    }

    private SortedMap<Integer, List<BranchData>> getNoHitBranchData(SortedMap<Integer, SortedSet<Integer>> branchMap) {
        TreeMap<Integer, List<BranchData>> branchData = new TreeMap<Integer, List<BranchData>>();
        if (branchMap.size() == 0) {
            return branchData;
        }
        for (int i : branchMap.keySet()) {
            ArrayList<BranchData> list = new ArrayList<BranchData>();
            branchData.put(i, list);
            for (int j = 0; j <= (Integer)((SortedSet)branchMap.get(i)).last(); ++j) {
                if (((SortedSet)branchMap.get(i)).contains(j)) {
                    list.add(new BranchData(0, 0, NO_CONDITIONS_ARE_COVERED, 0, 0));
                    continue;
                }
                list.add(null);
            }
        }
        return branchData;
    }
}

