/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.ExitHelper;
import jscover.report.ConfigurationForReport;
import jscover.report.FileData;
import jscover.report.JSONDataMerger;
import jscover.report.ReportFormat;
import jscover.report.SummaryData;
import jscover.report.coberturaxml.CoberturaData;
import jscover.report.coberturaxml.CoberturaXmlGenerator;
import jscover.report.lcov.LCovGenerator;
import jscover.report.xml.XMLSummary;
import jscover.util.IoService;
import jscover.util.IoUtils;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    public static final Properties properties = new Properties();
    private ExitHelper exitHelper = new ExitHelper();
    private XMLSummary xmlSummary = new XMLSummary();
    private CoberturaXmlGenerator coberturaXmlGenerator = new CoberturaXmlGenerator();
    private LCovGenerator lCovGenerator = new LCovGenerator();
    private JSONDataMerger jsonDataMerger = new JSONDataMerger();
    private IoUtils ioUtils = IoUtils.getInstance();
    private IoService ioService = new IoService(false);
    private ConfigurationForReport config = new ConfigurationForReport();

    public static void main(String[] args) throws IOException {
        new Main().runMain(args);
    }

    public void initialize() {
        this.ioUtils.loadProperties(properties, jscover.Main.class.getResourceAsStream("/jscover/configuration.properties"));
        this.config.setProperties(properties);
    }

    public void setConfig(ConfigurationForReport config) {
        this.config = config;
    }

    void runMain(String[] args) throws IOException {
        logger.log(Level.INFO, "Args: {0}", new jscover.Main().getArgsLogger(args));
        this.initialize();
        logger.log(Level.INFO, "Starting JSCover {0} merge", this.config.getVersion());
        this.config.parse(args);
        this.runReport();
        logger.log(Level.INFO, "Finished");
    }

    private void runReport() throws IOException {
        if (this.config.isInvalid()) {
            System.out.println(this.config.getHelpText());
            this.exitHelper.exit(1);
        } else if (this.config.showHelp().booleanValue()) {
            System.out.println(this.config.getHelpText());
        } else if (this.config.getReportFormat() == ReportFormat.LCOV) {
            this.generateLCovDataFile();
        } else if (this.config.getReportFormat() == ReportFormat.XMLSUMMARY) {
            this.saveXmlSummary();
        } else if (this.config.getReportFormat() == ReportFormat.COBERTURAXML) {
            this.saveCoberturaXml();
        } else if (this.config.isMerge()) {
            this.mergeReports();
        } else {
            System.out.println(this.config.getHelpText());
            this.exitHelper.exit(1);
        }
    }

    public void mergeReports() {
        this.config.getMergeDestDir().mkdirs();
        this.ioService.generateJSCoverFilesForWebServer(this.config.getMergeDestDir(), properties.getProperty("version"));
        this.mergeJSON();
        this.mergeOriginalSource();
    }

    private void mergeOriginalSource() {
        File srcDir = new File(this.config.getMergeDestDir(), "original-src");
        for (int i = 0; i < this.config.getMergeDirs().size(); ++i) {
            File jsOriginalSrc = new File(this.config.getMergeDirs().get(i), "original-src");
            if (jsOriginalSrc.exists()) {
                logger.log(Level.INFO, "Merging source from ''{0}''", jsOriginalSrc.getPath());
                this.ioUtils.copyDir(jsOriginalSrc, srcDir);
                continue;
            }
            logger.log(Level.INFO, "Couldn''t find directory ''{0}'' to merge", jsOriginalSrc);
        }
    }

    private void mergeJSON() {
        SortedMap<String, FileData> total = new TreeMap<String, FileData>();
        for (int i = 0; i < this.config.getMergeDirs().size(); ++i) {
            File dataFile = new File(this.config.getMergeDirs().get(i), "jscoverage.json");
            logger.log(Level.INFO, "Merging JSON from ''{0}''", dataFile.getPath());
            String json = this.ioUtils.loadFromFileSystem(dataFile);
            total = this.jsonDataMerger.mergeJSONCoverageMaps(total, this.jsonDataMerger.jsonToMap(json));
        }
        this.config.getMergeDestDir().mkdirs();
        File mergedJson = new File(this.config.getMergeDestDir(), "jscoverage.json");
        logger.log(Level.INFO, "Writing JSON to ''{0}''", mergedJson.getPath());
        this.ioUtils.copy(this.jsonDataMerger.toJSON(total), mergedJson);
    }

    public void generateLCovDataFile() {
        String json = this.ioUtils.loadFromFileSystem(new File(this.config.getJsonDirectory(), "jscoverage.json"));
        File lcovFile = new File(this.config.getJsonDirectory(), "jscover.lcov");
        this.lCovGenerator.saveData(this.jsonDataMerger.jsonToMap(json).values(), this.ioUtils.getCanonicalPath(this.config.getSourceDirectory()), lcovFile);
    }

    public void saveXmlSummary() {
        String json = this.ioUtils.loadFromFileSystem(new File(this.config.getJsonDirectory(), "jscoverage.json"));
        SummaryData summaryData = new SummaryData(this.jsonDataMerger.jsonToMap(json).values());
        this.xmlSummary.saveSummary(summaryData, this.config.getJsonDirectory(), this.config.getVersion());
    }

    public void saveCoberturaXml() {
        String json = this.ioUtils.loadFromFileSystem(new File(this.config.getJsonDirectory(), "jscoverage.json"));
        String xml = this.coberturaXmlGenerator.generateXml(new CoberturaData(this.jsonDataMerger.jsonToMap(json).values()), this.ioUtils.getCanonicalPath(this.config.getSourceDirectory()), this.config.getVersion());
        File dest = new File(this.config.getJsonDirectory(), "cobertura-coverage.xml");
        this.ioUtils.copy(xml, dest);
    }
}

