/*
 * Decompiled with CFR 0.152.
 */
package jscover.report.coberturaxml;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jscover.report.Coverable;
import jscover.report.SummaryData;

public class CoberturaData
extends SummaryData {
    private Map<String, Set<? extends Coverable>> packageMap = new HashMap<String, Set<? extends Coverable>>();
    private Collection<? extends Coverable> files;

    public CoberturaData(Collection<? extends Coverable> files) {
        super(files);
        this.files = files;
        for (Coverable coverable : files) {
            String path = this.getPackage(coverable.getUri());
            if (!this.packageMap.containsKey(path)) {
                this.packageMap.put(path, new HashSet());
            }
            this.packageMap.get(path).add(coverable);
        }
    }

    protected String getPackage(String uri) {
        if (uri == null || !uri.contains("/")) {
            return "";
        }
        return uri.substring(0, uri.lastIndexOf("/"));
    }

    public Collection<? extends Coverable> getFiles() {
        return this.files;
    }

    public Map<String, Set<? extends Coverable>> getPackageMap() {
        return this.packageMap;
    }
}

