/*
 * Decompiled with CFR 0.152.
 */
package jscover.report.coberturaxml;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jscover.report.BranchData;
import jscover.report.Coverable;
import jscover.report.FileData;
import jscover.report.SummaryData;
import jscover.report.coberturaxml.CoberturaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoberturaXmlGenerator {
    public String generateXml(CoberturaData data, String sourceDir, String version) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.newDocument();
            SummaryData summaryTotal = new SummaryData(data.getFiles());
            Element coverageElement = doc.createElement("coverage");
            doc.appendChild(coverageElement);
            this.addCoverageAttributes(version, summaryTotal, coverageElement);
            Element sources = doc.createElement("sources");
            coverageElement.appendChild(sources);
            Element source = doc.createElement("source");
            sources.appendChild(source);
            source.setTextContent(sourceDir.replaceAll("\\\\", "/"));
            Element packages = doc.createElement("packages");
            coverageElement.appendChild(packages);
            this.addPackages(data, doc, packages);
            return this.getXmlString(doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addCoverageAttributes(String version, SummaryData summaryTotal, Element root) {
        root.setAttribute("line-rate", "" + summaryTotal.getLineCoverRate());
        root.setAttribute("lines-covered", "" + summaryTotal.getCodeLinesCoveredCount());
        root.setAttribute("lines-valid", "" + summaryTotal.getCodeLineCount());
        root.setAttribute("branch-rate", "" + summaryTotal.getBranchRate());
        root.setAttribute("branches-covered", "" + summaryTotal.getBranchesCoveredCount());
        root.setAttribute("branches-valid", "" + summaryTotal.getBranchCount());
        root.setAttribute("complexity", "0");
        root.setAttribute("version", version);
        root.setAttribute("timestamp", "" + new Date().getTime());
    }

    private void addPackages(CoberturaData data, Document doc, Element packages) {
        for (String path : data.getPackageMap().keySet()) {
            Element packageElement = doc.createElement("package");
            packages.appendChild(packageElement);
            packageElement.setAttribute("name", path);
            Set<? extends Coverable> files = data.getPackageMap().get(path);
            SummaryData summaryPackage = new SummaryData(files);
            packageElement.setAttribute("line-rate", "" + summaryPackage.getLineCoverRate());
            packageElement.setAttribute("branch-rate", "" + summaryPackage.getBranchRate());
            packageElement.setAttribute("complexity", "0");
            Element classesElement = doc.createElement("classes");
            packageElement.appendChild(classesElement);
            this.addClasses(doc, files, classesElement);
        }
    }

    private void addClasses(Document doc, Set<? extends Coverable> files, Element classesElement) {
        for (Coverable coverable : files) {
            Element classElement = doc.createElement("class");
            classesElement.appendChild(classElement);
            classElement.setAttribute("name", coverable.getUri());
            classElement.setAttribute("filename", coverable.getUri().substring(1));
            classElement.setAttribute("line-rate", "" + coverable.getLineCoverRate());
            classElement.setAttribute("branch-rate", "" + coverable.getBranchRate());
            classElement.setAttribute("complexity", "0");
            classElement.appendChild(doc.createElement("methods"));
            Element linesElement = doc.createElement("lines");
            classElement.appendChild(linesElement);
            FileData fileData = (FileData)coverable;
            this.addLines(doc, linesElement, fileData);
        }
    }

    private void addLines(Document doc, Element linesElement, FileData fileData) {
        int maxLines = fileData.getLines().size();
        if (fileData.getBranchData().size() > 0) {
            maxLines = Math.max(fileData.getLines().size(), Collections.max(fileData.getBranchData().keySet()) + 1);
        }
        for (int i = 0; i < maxLines; ++i) {
            Element lineElement = this.addLineElement(doc, linesElement, fileData, i);
            this.addBranchElement(doc, linesElement, fileData, i, lineElement);
        }
    }

    private Element addLineElement(Document doc, Element linesElement, FileData fileData, int i) {
        Integer hits;
        if (i < fileData.getLines().size() && (hits = fileData.getLines().get(i)) != null) {
            Element lineElement = doc.createElement("line");
            linesElement.appendChild(lineElement);
            lineElement.setAttribute("number", "" + i);
            lineElement.setAttribute("hits", hits.toString());
            lineElement.setAttribute("branch", "false");
            return lineElement;
        }
        return null;
    }

    private void addBranchElement(Document doc, Element linesElement, FileData fileData, int i, Element lineElement) {
        if (fileData.getBranchData().keySet().contains(i)) {
            boolean wasHit;
            List branchDatas = (List)fileData.getBranchData().get(i);
            if (lineElement == null) {
                lineElement = doc.createElement("line");
                linesElement.appendChild(lineElement);
                lineElement.setAttribute("number", "" + i);
            }
            lineElement.setAttribute("hits", (wasHit = this.addBranches(doc, lineElement, branchDatas)) ? "1" : "0");
        }
    }

    private boolean addBranches(Document doc, Element lineElement, List<BranchData> branchDatas) {
        lineElement.setAttribute("branch", "true");
        Element conditionsElement = doc.createElement("conditions");
        lineElement.appendChild(conditionsElement);
        int branches = 0;
        int branchHits = 0;
        for (int j = 1; j < branchDatas.size(); ++j) {
            Element conditionElement = doc.createElement("condition");
            conditionsElement.appendChild(conditionElement);
            conditionElement.setAttribute("number", "" + j);
            conditionElement.setAttribute("type", "jump");
            BranchData branchData = branchDatas.get(j);
            conditionElement.setAttribute("coverage", String.format("%d%%", branchData.getCoverage()));
            branches += 2;
            if (branchData.getEvalFalse() > 0) {
                ++branchHits;
            }
            if (branchData.getEvalTrue() <= 0) continue;
            ++branchHits;
        }
        lineElement.setAttribute("condition-coverage", String.format("%d%% (%d/%d)", Math.round((double)branchHits * 100.0 / (double)branches), branchHits, branches));
        return branchHits > 0;
    }

    private String getXmlString(Document doc) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
        transformer.setOutputProperty("doctype-system", "http://cobertura.sourceforge.net/xml/coverage-04.dtd");
        StringWriter writer = new StringWriter();
        DOMSource xmlSource = new DOMSource(doc.getDocumentElement());
        transformer.transform(xmlSource, new StreamResult(writer));
        return writer.getBuffer().toString();
    }
}

