/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import jscover.server.MIME;

public class HttpRequest {
    private String path;
    private URL url;
    private Map<String, List<String>> headers;
    private InputStream inputStream;
    private OutputStream outputStream;
    private int postIndex;

    public HttpRequest(String path, InputStream inputStream, OutputStream outputStream, int postIndex, Map<String, List<String>> headers) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.postIndex = postIndex;
        this.headers = headers;
        try {
            this.url = new URL(path);
            this.path = HttpRequest.urlDecode(this.url.getPath());
        }
        catch (MalformedURLException e) {
            path = HttpRequest.urlDecode(path);
            int index = path.indexOf("?");
            if (index > 0) {
                path = path.substring(0, index);
            }
            this.path = path.replaceAll("//", "/");
        }
    }

    public static String urlDecode(String path) {
        try {
            return URLDecoder.decode(path, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected MIME getMime() {
        String extension = null;
        int dot = this.path.lastIndexOf(46);
        if (dot >= 0) {
            extension = this.path.substring(dot + 1).toLowerCase();
        }
        return MIME.getMime(extension);
    }

    public String getRelativePath() {
        return this.getPath().startsWith("/") ? this.getPath().substring(1) : this.getPath();
    }

    public URL getUrl() {
        return this.url;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public int getContentLength() {
        return Integer.valueOf(this.headers.get("Content-Length").get(0));
    }

    public boolean skipInstrumentation() {
        return this.getHeaders() != null && this.getHeaders().containsKey("NoInstrument");
    }
}

