/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.server.HTTP_STATUS;
import jscover.server.HttpRequest;
import jscover.server.MIME;
import jscover.util.IoUtils;

public class HttpServer
extends Thread {
    private static final Logger logger = Logger.getLogger(HttpServer.class.getName());
    public static final int HEADER_SIZE = 5120;
    private Socket socket;
    private String version;
    protected File wwwRoot;
    protected InputStream is;
    protected PushbackInputStream pbis;
    protected ByteArrayInputStream bais;
    protected OutputStream os;
    protected PrintWriter pw = null;
    protected IoUtils ioUtils = IoUtils.getInstance();

    public HttpServer(Socket socket, File wwwRoot, String version) {
        this.wwwRoot = wwwRoot;
        this.socket = socket;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            BufferedReader br = null;
            String requestString = null;
            try {
                this.is = this.socket.getInputStream();
                this.os = this.socket.getOutputStream();
                this.pbis = new PushbackInputStream(this.is, 5120);
                byte[] headerBytes = new byte[5120];
                int read = this.pbis.read(headerBytes);
                this.bais = new ByteArrayInputStream(headerBytes, 0, read);
                br = new BufferedReader(new InputStreamReader(this.bais));
                this.pw = new PrintWriter(this.os);
                requestString = br.readLine();
                logger.log(Level.FINE, "Request: {0}", requestString);
                if (requestString == null) {
                    this.ioUtils.flushQuietly(this.pw);
                    this.ioUtils.flushQuietly(this.os);
                    this.ioUtils.closeQuietly(br);
                    this.ioUtils.closeQuietly(this.pbis);
                    this.ioUtils.closeQuietly(this.os);
                    this.ioUtils.closeQuietly(this.socket);
                    logger.log(Level.FINEST, "Socket closed");
                    return;
                }
                StringTokenizer tokenizer = new StringTokenizer(requestString);
                String httpMethod = tokenizer.nextToken();
                String path = tokenizer.nextToken();
                Map<String, List<String>> headers = this.readHeaders(br);
                int dataIndex = 0;
                if (httpMethod.equals("POST") || httpMethod.equals("PUT")) {
                    dataIndex = this.ioUtils.getDataIndex(headerBytes, Charset.defaultCharset());
                }
                HttpRequest httpRequest = new HttpRequest(path, this.pbis, this.os, dataIndex, headers);
                this.pbis.unread(headerBytes, 0, read);
                if (httpMethod.equals("GET")) {
                    if (httpRequest.getPath().equals("/stop")) {
                        logger.info("Shutting down the server.");
                        this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.TEXT_PLAIN, "Shutting down the server.");
                        this.ioUtils.closeQuietly(br);
                        this.ioUtils.closeQuietly(this.pbis);
                        this.ioUtils.closeQuietly(this.os);
                        System.exit(0);
                    }
                    this.handleGet(httpRequest);
                } else if (httpMethod.equals("POST") || httpMethod.equals("PUT")) {
                    this.handlePostOrPut(httpRequest);
                } else {
                    this.handleOther(httpMethod, httpRequest);
                }
                this.ioUtils.flushQuietly(this.pw);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, String.format("Error processing request string %s", requestString), e);
                break block13;
            }
            finally {
                this.ioUtils.flushQuietly(this.pw);
                this.ioUtils.flushQuietly(this.os);
                this.ioUtils.closeQuietly(br);
                this.ioUtils.closeQuietly(this.pbis);
                this.ioUtils.closeQuietly(this.os);
                this.ioUtils.closeQuietly(this.socket);
                logger.log(Level.FINEST, "Socket closed");
            }
            this.ioUtils.flushQuietly(this.os);
            this.ioUtils.closeQuietly(br);
            this.ioUtils.closeQuietly(this.pbis);
            this.ioUtils.closeQuietly(this.os);
            this.ioUtils.closeQuietly(this.socket);
            logger.log(Level.FINEST, "Socket closed");
        }
    }

    protected Map<String, List<String>> readHeaders(BufferedReader br) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        String headerLine = br.readLine();
        while (headerLine != null && !headerLine.equals("")) {
            logger.log(Level.FINEST, "Header: {0}", headerLine);
            int index = headerLine.indexOf(58);
            if (index >= 0) {
                String headerField = headerLine.substring(0, index).trim();
                String headerValue = headerLine.substring(index + 1).trim();
                if (!headers.containsKey(headerField)) {
                    headers.put(headerField, new ArrayList());
                }
                ((List)headers.get(headerField)).add(headerValue);
            }
            headerLine = br.readLine();
        }
        return headers;
    }

    protected void handleOther(String method, HttpRequest httpRequest) {
        throw new UnsupportedOperationException("No support for " + method);
    }

    protected void handlePostOrPut(HttpRequest request) {
        try {
            request.getInputStream().skip(request.getPostIndex());
            String response = String.format("<html><body>Posted<pre id=\"postData\">%s</pre></body></html>", this.ioUtils.toStringNoClose(request.getInputStream(), request.getContentLength()));
            this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.HTML, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleGet(HttpRequest request) throws IOException {
        String path = request.getRelativePath();
        File file = new File(this.wwwRoot, path);
        if (!file.exists()) {
            String data = "<html><body>Not found</body></html>";
            this.sendResponse(HTTP_STATUS.HTTP_FILE_NOT_FOUND, MIME.HTML, data);
        } else if (file.isFile()) {
            this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), file);
        } else {
            StringBuilder data = new StringBuilder();
            data.append("<html>\n<body>\n");
            data.append(String.format("<h1>Directory %s</h1>\n", request.getPath()));
            File parentDir = file.getParentFile();
            if (!file.equals(this.wwwRoot)) {
                if (parentDir.equals(this.wwwRoot)) {
                    data.append("<a href=\"/\">..</a><br/>\n");
                } else {
                    data.append("<a href=\"..\">..</a><br/>\n");
                }
            }
            Object[] files = file.listFiles();
            Arrays.sort(files);
            for (Object linkTo : files) {
                String relativePath = this.getRelativePath(file, (File)linkTo);
                data.append(String.format("<a href=\"%s\">%s</a><br/>\n", relativePath, relativePath));
            }
            data.append("</body>\n</html>");
            this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.HTML, data.toString());
        }
    }

    private String getRelativePath(File base, File linkTo) {
        String path = base.toURI().relativize(linkTo.toURI()).getPath();
        return path.replaceAll("\\\\", "/");
    }

    private void sendPartialHeader(HTTP_STATUS status, MIME mime) {
        logger.log(Level.FINE, "Sending response status:{0} mime:{1}", new Object[]{status, mime.getContentType()});
        this.pw.print(String.format("HTTP/1.0 %s\n", new Object[]{status}));
        this.pw.write(String.format("Server: JSCover/%s\n", this.version));
        this.pw.write(String.format("Content-Type: %s\n", mime.getContentType()));
        this.pw.write("Connection: close\n");
    }

    protected void sendResponse(HTTP_STATUS status, MIME mime, String data) {
        this.sendPartialHeader(status, mime);
        this.pw.write(String.format("Content-Length: %d\n\n", data.getBytes().length));
        this.pw.write(data);
        this.pw.flush();
    }

    private void sendResponse(HTTP_STATUS status, MIME mime, File data) {
        this.sendPartialHeader(status, mime);
        this.pw.write(String.format("Content-Length: %d\n\n", data.length()));
        this.pw.flush();
        this.ioUtils.copyNoClose(data, this.os);
    }

    protected void sendResponse(HTTP_STATUS status, MIME mime, InputStream is) {
        this.sendPartialHeader(status, mime);
        this.pw.write("\n");
        this.pw.flush();
        this.ioUtils.copy(is, this.os);
    }
}

