/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jscover.server.HttpRequest;
import jscover.util.IoUtils;

public class ProxyService {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger logger = Logger.getLogger(ProxyService.class.getName());
    private IoUtils ioUtils = IoUtils.getInstance();

    protected void handleProxyGet(HttpRequest request, OutputStream os) {
        this.handleProxyRequest(request, os, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProxyRequest(HttpRequest request, OutputStream os, String method) {
        logger.log(Level.FINE, "handleProxyRequest for {0}", request.getUrl());
        URL url = request.getUrl();
        Socket socket = null;
        InputStream remoteInputStream = null;
        OutputStream remoteOutputStream = null;
        try {
            int port = url.getPort();
            socket = new Socket(url.getHost(), port == -1 ? 80 : port);
            remoteInputStream = socket.getInputStream();
            remoteOutputStream = socket.getOutputStream();
            PrintWriter remotePrintWriter = new PrintWriter(remoteOutputStream);
            String uri = this.getRawURI(url);
            remotePrintWriter.print(method + " " + uri + " HTTP/1.0\n");
            this.sendHeaders(request, remotePrintWriter);
            this.ioUtils.copyNoClose(remoteInputStream, os);
            this.ioUtils.closeQuietly(remoteOutputStream);
            this.ioUtils.closeQuietly(remoteInputStream);
            this.ioUtils.closeQuietly(socket);
        }
        catch (IOException e) {
            try {
                logger.log(Level.SEVERE, request.getUrl().toString(), e);
                this.ioUtils.closeQuietly(remoteOutputStream);
                this.ioUtils.closeQuietly(remoteInputStream);
                this.ioUtils.closeQuietly(socket);
            }
            catch (Throwable throwable) {
                this.ioUtils.closeQuietly(remoteOutputStream);
                this.ioUtils.closeQuietly(remoteInputStream);
                this.ioUtils.closeQuietly(socket);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProxyPostOrPut(HttpRequest request) {
        URL url = request.getUrl();
        Socket socket = null;
        InputStream remoteInputStream = null;
        OutputStream remoteOutputStream = null;
        try {
            int port = url.getPort();
            socket = new Socket(url.getHost(), port == -1 ? 80 : port);
            remoteInputStream = socket.getInputStream();
            remoteOutputStream = socket.getOutputStream();
            this.sendMethodAndHeaders(request, request.getInputStream(), remoteOutputStream);
            this.ioUtils.copyNoClose(remoteInputStream, request.getOutputStream());
            this.ioUtils.closeQuietly(remoteOutputStream);
            this.ioUtils.closeQuietly(remoteInputStream);
            this.ioUtils.closeQuietly(socket);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.ioUtils.closeQuietly(remoteOutputStream);
            this.ioUtils.closeQuietly(remoteInputStream);
            this.ioUtils.closeQuietly(socket);
        }
    }

    protected void sendMethodAndHeaders(HttpRequest request, InputStream is, OutputStream remoteOutputStream) throws IOException {
        logger.log(Level.FINE, "Bytes available on stream {0}", is.available());
        int bufSize = Math.min(is.available(), 5120);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bufSize);
        PushbackInputStream pbis = new PushbackInputStream(is, bufSize);
        byte[] headerBytes = new byte[bufSize];
        int read = pbis.read(headerBytes);
        int firstLineIndex = this.ioUtils.getNewLineIndex(headerBytes, UTF8);
        int dataIndex = this.ioUtils.getDataIndex(headerBytes, UTF8);
        pbis.unread(headerBytes, dataIndex, read - dataIndex);
        String header = new String(headerBytes, 0, firstLineIndex, UTF8);
        logger.log(Level.FINEST, "Header before {0}", header);
        URL url = request.getUrl();
        header = header.replaceFirst(Pattern.quote(url.toExternalForm()), this.getRawURI(url));
        header = header.replaceFirst("HTTP/1.1", "HTTP/1.0");
        logger.log(Level.FINEST, "Header after {0}", header);
        PrintWriter remotePrintWriter = new PrintWriter(new OutputStreamWriter((OutputStream)baos, UTF8));
        remotePrintWriter.write(header);
        remotePrintWriter.write("\r\n");
        this.sendHeaders(request, remotePrintWriter);
        byte[] methodAndHeaderBytes = baos.toByteArray();
        PushbackInputStream requestInputStream = new PushbackInputStream(pbis, methodAndHeaderBytes.length);
        requestInputStream.unread(methodAndHeaderBytes);
        int toSend = methodAndHeaderBytes.length + request.getContentLength();
        this.ioUtils.copyNoClose(requestInputStream, remoteOutputStream, toSend);
    }

    String getRawURI(URL url) {
        String uri = url.getPath();
        if (url.getQuery() != null && url.getQuery().length() != 0) {
            uri = uri + "?" + url.getQuery();
        }
        return uri;
    }

    private void sendHeaders(HttpRequest request, PrintWriter remotePrintWriter) {
        Map<String, List<String>> clientHeaders = request.getHeaders();
        for (String header : clientHeaders.keySet()) {
            if (!this.shouldSendHeader(header)) continue;
            List<String> values = clientHeaders.get(header);
            for (String value : values) {
                remotePrintWriter.print(String.format("%s: %s\r\n", header, value));
            }
        }
        remotePrintWriter.print("\r\n");
        remotePrintWriter.flush();
    }

    protected boolean shouldSendHeader(String header) {
        if ("proxy-connection".equals(header = header.toLowerCase()) || "connection".equals(header)) {
            return false;
        }
        return !"accept-encoding".equals(header);
    }

    public String getUrl(HttpRequest request) throws IOException {
        URL url = request.getUrl();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        this.copyHeadersExceptEncoding(request, conn);
        return this.ioUtils.toString(conn.getInputStream());
    }

    void copyHeadersExceptEncoding(HttpRequest request, HttpURLConnection conn) {
        Map<String, List<String>> clientHeaders = request.getHeaders();
        if (clientHeaders != null) {
            for (String header : clientHeaders.keySet()) {
                if (!this.shouldSendHeader(header)) continue;
                List<String> values = clientHeaders.get(header);
                for (String value : values) {
                    conn.addRequestProperty(header, value);
                }
            }
        }
    }
}

