/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.ConfigurationCommon;
import jscover.server.ConfigurationForServer;
import jscover.util.IoUtils;

public class FileScanner {
    private static final Logger logger = Logger.getLogger(FileScanner.class.getName());
    private ConfigurationCommon configuration;
    private File scanPath;
    private IoUtils ioUtils = IoUtils.getInstance();
    private File reportSrc;

    public FileScanner(ConfigurationCommon configuration, File scanPath) {
        this.configuration = configuration;
        this.scanPath = scanPath;
        if (configuration instanceof ConfigurationForServer) {
            this.reportSrc = new File(((ConfigurationForServer)configuration).getReportDir(), "original-src");
        }
    }

    public Set<File> getFiles(Set<String> urisAlreadyProcessed) {
        HashSet<File> files = new HashSet<File>();
        this.searchFolder(this.scanPath, files, urisAlreadyProcessed);
        return files;
    }

    private void searchFolder(File src, Set<File> list, Set<String> urisAlreadyProcessed) {
        if (this.inReportSrc(src)) {
            return;
        }
        if (src.isDirectory()) {
            for (String file : src.list()) {
                this.searchFolder(new File(src, file), list, urisAlreadyProcessed);
            }
        } else {
            if (!src.getName().endsWith(".js")) {
                return;
            }
            String path = this.ioUtils.getRelativePath(src, this.scanPath);
            logger.log(Level.FINEST, "Checking path {0}", path);
            if (!urisAlreadyProcessed.contains(path) && !this.configuration.skipInstrumentation(path)) {
                logger.log(Level.FINE, "Adding path {0}", path);
                list.add(src);
            }
        }
    }

    private boolean inReportSrc(File src) {
        if (this.reportSrc == null) {
            return false;
        }
        return this.ioUtils.isSubDirectory(src, this.reportSrc);
    }
}

