/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import jscover.util.DateTime;
import jscover.util.DateTimeImpl;
import jscover.util.IoUtils;

public class IoService {
    private IoUtils ioUtils = IoUtils.getInstance();
    private DateTime dateTime = new DateTimeImpl();
    private boolean localStorage;

    public IoService(boolean localStorage) {
        this.localStorage = localStorage;
    }

    public void generateJSCoverFilesForFileSystem(File destDir, String version) {
        this.generateJSCoverFiles(destDir, version, false);
    }

    public void generateJSCoverFilesForWebServer(File destDir, String version) {
        this.generateJSCoverFiles(destDir, version, true);
    }

    private void generateJSCoverFiles(File destDir, String version, boolean isServer) {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        this.copyResourceToDir("jscoverage.css", destDir);
        String reportHTML = this.generateJSCoverageHtml(version);
        this.ioUtils.copy(reportHTML, new File(destDir, "jscoverage.html"));
        if (isServer) {
            String reportJS = this.generateJSCoverageReportJS();
            this.ioUtils.copy(reportJS, new File(destDir, "jscoverage.js"));
        } else {
            String jsCoverageJS = this.generateJSCoverageJs();
            this.ioUtils.copy(jsCoverageJS, new File(destDir, "jscoverage.js"));
            if (this.localStorage) {
                this.copyResourceToDir("jscoverage-clear-local-storage.html", destDir);
            }
        }
        this.copyResourceToDir("jscoverage-highlight.css", destDir);
        this.copyResourceToDir("jscoverage-ie.css", destDir);
        this.copyResourceToDir("jscoverage-throbber.gif", destDir);
    }

    private String generateJSCoverageReportJS() {
        return this.generateJSCoverageJs() + "\njscoverage_isReport = true;";
    }

    public String generateJSCoverageServerJS() {
        return this.generateJSCoverageJs() + "\njscoverage_isServer = true;";
    }

    private String generateJSCoverageJs() {
        String mainJS = this.ioUtils.loadFromClassPath("/jscoverage.js");
        String branchJS = this.ioUtils.loadFromClassPath("/jscoverage-branch.js");
        String commonJS = this.ioUtils.loadFromClassPath("/jscoverage-common.js");
        String localStorageJS = this.localStorage ? this.ioUtils.loadFromClassPath("/jscoverage-localstorage.js") : "";
        return branchJS + commonJS + localStorageJS + mainJS;
    }

    public String generateJSCoverageHtml(String version) {
        String timeStamp = new SimpleDateFormat("HH:mm:ss dd MMM yyyy").format(this.dateTime.getDate());
        return this.ioUtils.loadFromClassPath("/jscoverage.html").replaceAll("@@version@@", version).replaceAll("@@timestamp@@", timeStamp);
    }

    private void copyResourceToDir(String resource, File parent) {
        this.ioUtils.copy(this.getResourceAsStream("/" + resource), new File(parent, resource));
    }

    public InputStream getResourceAsStream(String uri) {
        return this.getClass().getResourceAsStream(uri);
    }
}

