/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenVerifier;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Optional;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTAuthProvider<T>
implements InjectableProvider<Auth, Parameter> {
    private final Authenticator<JsonWebToken, T> authenticator;
    private final JsonWebTokenParser tokenParser;
    private final JsonWebTokenVerifier tokenVerifier;
    private final String realm;

    public JWTAuthProvider(Authenticator<JsonWebToken, T> authenticator, JsonWebTokenParser tokenParser, JsonWebTokenVerifier tokenVerifier, String realm) {
        this.authenticator = authenticator;
        this.tokenParser = tokenParser;
        this.tokenVerifier = tokenVerifier;
        this.realm = realm;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Injectable<?> getInjectable(ComponentContext ic, Auth a, Parameter c) {
        return new JWTAuthInjectable(this.authenticator, this.tokenParser, this.tokenVerifier, this.realm, a.required());
    }

    private static class JWTAuthInjectable<T>
    extends AbstractHttpContextInjectable<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(JWTAuthInjectable.class);
        private static final String CHALLENGE_FORMAT = "Bearer realm=\"%s\"";
        private static final String PREFIX = "bearer";
        private final Authenticator<JsonWebToken, T> authenticator;
        private final String realm;
        private final boolean required;
        private final JsonWebTokenVerifier tokenVerifier;
        private final JsonWebTokenParser tokenParser;

        private JWTAuthInjectable(Authenticator<JsonWebToken, T> authenticator, JsonWebTokenParser tokenParser, JsonWebTokenVerifier tokenVerifier, String realm, boolean required) {
            this.authenticator = authenticator;
            this.tokenParser = tokenParser;
            this.tokenVerifier = tokenVerifier;
            this.realm = realm;
            this.required = required;
        }

        public T getValue(HttpContext c) {
            block6: {
                try {
                    String method;
                    int space;
                    String header = c.getRequest().getHeaderValue("Authorization");
                    if (header == null || (space = header.indexOf(32)) <= 0 || !PREFIX.equalsIgnoreCase(method = header.substring(0, space))) break block6;
                    String rawToken = header.substring(space + 1);
                    JsonWebToken token = null;
                    try {
                        token = this.tokenParser.parse(rawToken);
                        this.tokenVerifier.verifySignature(token);
                    }
                    catch (Exception e) {
                        throw new AuthenticationException(e.getMessage(), (Throwable)e);
                    }
                    Optional result = this.authenticator.authenticate((Object)token);
                    if (result.isPresent()) {
                        return (T)result.get();
                    }
                }
                catch (AuthenticationException e) {
                    LOGGER.warn("Error authenticating credentials", (Throwable)e);
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            if (this.required) {
                String challenge = String.format(CHALLENGE_FORMAT, this.realm);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)challenge).entity((Object)"Credentials are required to access this resource.").type(MediaType.TEXT_PLAIN_TYPE).build());
            }
            return null;
        }
    }
}

