/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.hmac;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenSigner;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSigner;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.KeyAware;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Preconditions;

public class HmacSHA256Signer
extends KeyAware
implements JsonWebTokenSigner {
    private static final String HMAC_SHA256_ALG = "HmacSHA256";

    public HmacSHA256Signer(byte[] secret) {
        super(secret, HMAC_SHA256_ALG);
    }

    @Override
    public String algorithm() {
        return "HS256";
    }

    @Override
    public String sign(JsonWebToken token) {
        Preconditions.checkArgument((boolean)token.header().algorithm().equals("HS256"), (String)"Can not sign a %s with a %s signer", (Object[])new Object[]{token.header().algorithm(), "HS256"});
        return new HmacSigner(this.initialiseMac()).sign(token);
    }
}

