/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.hmac;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenVerifier;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacVerifier;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.KeyAware;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Preconditions;

public class HmacSHA256Verifier
extends KeyAware
implements JsonWebTokenVerifier {
    private static final String HMAC_SHA256_ALG = "HmacSHA256";

    public HmacSHA256Verifier(byte[] secret) {
        super(secret, HMAC_SHA256_ALG);
    }

    @Override
    public String algorithm() {
        return "HS256";
    }

    @Override
    public void verifySignature(JsonWebToken token) {
        Preconditions.checkArgument((boolean)token.header().algorithm().equals("HS256"), (String)"Can not verify a %s with a %s verifier", (Object[])new Object[]{token.header().algorithm(), "HS256"});
        new HmacVerifier(this.initialiseMac()).verifySignature(token);
    }
}

