/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.hmac;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenVerifier;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacVerifier;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.KeyAware;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Preconditions;

public class HmacSHA384Verifier
extends KeyAware
implements JsonWebTokenVerifier {
    private static final String HMAC_SHA384_ALG = "HmacSHA384";

    public HmacSHA384Verifier(byte[] secret) {
        super(secret, HMAC_SHA384_ALG);
    }

    @Override
    public String algorithm() {
        return "HS384";
    }

    @Override
    public void verifySignature(JsonWebToken token) {
        Preconditions.checkArgument((boolean)token.header().algorithm().equals("HS384"), (String)"Can not verify a %s with a %s verifier", (Object[])new Object[]{token.header().algorithm(), "HS384"});
        new HmacVerifier(this.initialiseMac()).verifySignature(token);
    }
}

