/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.hmac;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenUtils;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.TokenCreationException;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import javax.crypto.Mac;

public class HmacSigner {
    private final Mac hmac;

    HmacSigner(Mac hmac) {
        this.hmac = hmac;
    }

    public String sign(JsonWebToken token) {
        Preconditions.checkNotNull((Object)token);
        String payload = JsonWebTokenUtils.payloadOf(token);
        String signature = JsonWebTokenUtils.toBase64(this.sign(JsonWebTokenUtils.bytesOf(payload)));
        return Joiner.on((String)".").join((Object)payload, (Object)signature, new Object[0]);
    }

    private byte[] sign(byte[] input) {
        try {
            return this.hmac.doFinal(input);
        }
        catch (Exception e) {
            throw new TokenCreationException(e.getMessage(), e);
        }
    }
}

