/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.hmac;

import com.github.toastshaman.dropwizard.auth.jwt.exceptions.JsonWebTokenException;
import com.google.common.base.Preconditions;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;

public abstract class KeyAware {
    protected final byte[] secret;
    private final String algorithm;

    KeyAware(byte[] secret, String algorithm) {
        Preconditions.checkNotNull((Object)secret);
        Preconditions.checkNotNull((Object)algorithm);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)algorithm));
        this.algorithm = algorithm;
        this.secret = secret;
    }

    protected Mac initialiseMac() {
        SecretKeySpec signingKey = new SecretKeySpec(this.secret, this.algorithm);
        try {
            Mac hmac = Mac.getInstance(this.algorithm);
            hmac.init(signingKey);
            return hmac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JsonWebTokenException(e.getMessage(), e);
        }
    }
}

