/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenUtils;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.JsonWebTokenException;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.MalformedJsonWebTokenException;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebTokenClaim;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebTokenHeader;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JsonWebToken {
    private final JsonWebTokenHeader header;
    private final JsonWebTokenClaim claim;
    private Optional<byte[]> signature;
    private Optional<List<String>> rawToken = Optional.absent();

    private JsonWebToken(JsonWebTokenHeader header, JsonWebTokenClaim claim, Optional<byte[]> signature, Optional<List<String>> rawToken) {
        this.header = header;
        this.claim = claim;
        this.signature = signature;
        this.rawToken = rawToken;
    }

    public JsonWebTokenHeader header() {
        return this.header;
    }

    public JsonWebTokenClaim claim() {
        return this.claim;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.orNull();
    }

    public String deserialize() {
        return Joiner.on((String)".").join((Object)JsonWebTokenUtils.toBase64(JsonWebTokenUtils.bytesOf(this.toJson(this.header))), (Object)JsonWebTokenUtils.toBase64(JsonWebTokenUtils.bytesOf(this.toJson(this.claim))), new Object[0]);
    }

    private String toJson(Object input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter output = new StringWriter();
            mapper.writeValue((Writer)output, input);
            return output.toString();
        }
        catch (IOException e) {
            throw new JsonWebTokenException(e.getMessage(), e);
        }
    }

    public Optional<List<String>> getRawToken() {
        return this.rawToken;
    }

    public static DecoderBuilder parser() {
        return new DecoderBuilder();
    }

    public static EncoderBuilder builder() {
        return new EncoderBuilder();
    }

    public static class EncoderBuilder {
        private JsonWebTokenHeader header;
        private JsonWebTokenClaim claim;

        public EncoderBuilder header(JsonWebTokenHeader header) {
            Preconditions.checkNotNull((Object)header);
            this.header = header;
            return this;
        }

        public EncoderBuilder claim(JsonWebTokenClaim claim) {
            Preconditions.checkNotNull((Object)claim);
            this.claim = claim;
            return this;
        }

        public JsonWebToken build() {
            Preconditions.checkNotNull((Object)this.claim, (Object)"can not build a token without a JWT header");
            Preconditions.checkNotNull((Object)this.header, (Object)"can not build a token without a JWT claim");
            return new JsonWebToken(this.header, this.claim, Optional.absent(), Optional.absent());
        }
    }

    public static class DecoderBuilder {
        private ObjectMapper mapper = new ObjectMapper();
        private JsonWebTokenHeader header;
        private JsonWebTokenClaim claim;
        private Optional<byte[]> signature = Optional.absent();
        private Optional<List<String>> rawToken = Optional.absent();

        public JsonWebToken build() {
            Preconditions.checkNotNull((Object)this.header);
            Preconditions.checkNotNull((Object)this.claim);
            Preconditions.checkNotNull(this.rawToken);
            if (this.signature.isPresent()) {
                Preconditions.checkArgument((((byte[])this.signature.get()).length > 0 ? 1 : 0) != 0);
            }
            if (this.rawToken.isPresent()) {
                Preconditions.checkArgument((((List)this.rawToken.get()).size() == 3 ? 1 : 0) != 0);
            }
            return new JsonWebToken(this.header, this.claim, this.signature, this.rawToken);
        }

        public DecoderBuilder header(String header) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)header));
            try {
                this.header = (JsonWebTokenHeader)this.mapper.readValue(header, JsonWebTokenHeader.class);
                return this;
            }
            catch (Exception e) {
                throw new MalformedJsonWebTokenException(String.format("The provided JWT header is malformed: [%s]", header), e);
            }
        }

        public DecoderBuilder claim(String claim) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)claim));
            try {
                this.claim = (JsonWebTokenClaim)this.mapper.readValue(claim, JsonWebTokenClaim.class);
                return this;
            }
            catch (Exception e) {
                throw new MalformedJsonWebTokenException(String.format("The provided JWT claim is malformed: [%s]", claim), e);
            }
        }

        public DecoderBuilder signature(byte[] signature) {
            Preconditions.checkNotNull((Object)signature);
            Preconditions.checkArgument((signature.length > 0 ? 1 : 0) != 0);
            this.signature = Optional.of((Object)Arrays.copyOf(signature, signature.length));
            return this;
        }

        public DecoderBuilder rawToken(List<String> rawToken) {
            Preconditions.checkNotNull(rawToken);
            Preconditions.checkArgument((rawToken.size() == 3 ? 1 : 0) != 0);
            this.rawToken = Optional.of((Object)ImmutableList.copyOf(rawToken));
            return this;
        }
    }
}

