/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class JsonWebTokenClaim {
    @JsonProperty(value="iss")
    private String iss;
    @JsonProperty(value="exp")
    private Long exp;
    @JsonProperty(value="iat")
    private Long iat;
    @JsonProperty(value="nbf")
    private Long nbf;
    @JsonProperty(value="sub")
    private String sub;
    private Map<String, Object> params = Maps.newHashMap();

    private JsonWebTokenClaim() {
    }

    private JsonWebTokenClaim(String sub, String iss, Long iat, Long exp, Long nbf, Map<String, Object> params) {
        this.sub = sub;
        this.iss = iss;
        this.exp = exp;
        this.iat = iat;
        this.nbf = nbf;
        this.params = ImmutableMap.copyOf(params);
    }

    public Long expiration() {
        return this.exp;
    }

    public String issuer() {
        return this.iss;
    }

    public Long issuedAt() {
        return this.iat;
    }

    public Long notBefore() {
        return this.nbf;
    }

    public String subject() {
        return this.sub;
    }

    @JsonAnySetter
    private void addParameter(String key, Object object) {
        this.params.put(key, object);
    }

    @JsonAnyGetter
    private Map<String, Object> getParameters() {
        return this.params;
    }

    public Object getParameter(String key) {
        return this.params.get(key);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sub;
        private String iss;
        private Long exp;
        private Long iat;
        private Long nbf;
        private Map<String, Object> params = Maps.newHashMap();

        public JsonWebTokenClaim build() {
            return new JsonWebTokenClaim(this.sub, this.iss, this.iat, this.exp, this.nbf, this.params);
        }

        public Builder subject(String sub) {
            Preconditions.checkNotNull((Object)sub);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)sub));
            this.sub = sub;
            return this;
        }

        public Builder issuer(String iss) {
            Preconditions.checkNotNull((Object)iss);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)iss));
            this.iss = iss;
            return this;
        }

        public Builder expiration(DateTime time) {
            Preconditions.checkNotNull((Object)time);
            this.exp = time.getMillis() / 1000L;
            return this;
        }

        public Builder issuedAt(DateTime time) {
            Preconditions.checkNotNull((Object)time);
            this.iat = time.getMillis() / 1000L;
            return this;
        }

        public Builder notBefore(DateTime time) {
            Preconditions.checkNotNull((Object)time);
            this.nbf = time.getMillis() / 1000L;
            return this;
        }

        public Builder param(String key, Object value) {
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull((Object)value);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key));
            this.params.put(key, value);
            return this;
        }
    }
}

