/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class JsonWebTokenHeader {
    private static final String JWT_HEADER = "JWT";
    @JsonProperty(value="typ")
    @NotEmpty
    private String typ;
    @JsonProperty(value="alg")
    @NotEmpty
    private String alg;

    private JsonWebTokenHeader() {
    }

    private JsonWebTokenHeader(String typ, String alg) {
        this.typ = typ;
        this.alg = alg;
    }

    public String algorithm() {
        return this.alg;
    }

    public String type() {
        return this.typ;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JsonWebTokenHeader HS256() {
        return new JsonWebTokenHeader(JWT_HEADER, "HS256");
    }

    public static JsonWebTokenHeader HS384() {
        return new JsonWebTokenHeader(JWT_HEADER, "HS384");
    }

    public static JsonWebTokenHeader HS512() {
        return new JsonWebTokenHeader(JWT_HEADER, "HS512");
    }

    public static class Builder {
        private String typ;
        private String alg;
        private Map<String, Object> params = Maps.newHashMap();

        public JsonWebTokenHeader build() {
            Preconditions.checkNotNull((Object)this.alg);
            Preconditions.checkNotNull((Object)this.typ);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.alg));
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.typ));
            return new JsonWebTokenHeader(this.typ, this.alg);
        }

        public Builder algorithm(String alg) {
            Preconditions.checkNotNull((Object)alg);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)alg));
            this.alg = alg.toUpperCase();
            return this;
        }

        public Builder type(String typ) {
            Preconditions.checkNotNull((Object)typ);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)typ));
            this.typ = typ.toUpperCase();
            return this;
        }
    }
}

