/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenVerifier;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Optional;
import io.dropwizard.auth.AuthFactory;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.DefaultUnauthorizedHandler;
import io.dropwizard.auth.UnauthorizedHandler;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTAuthFactory<T>
extends AuthFactory<JsonWebToken, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JWTAuthFactory.class);
    private final boolean required;
    private final Class<T> generatedClass;
    private final String realm;
    private String prefix = "Bearer";
    private UnauthorizedHandler unauthorizedHandler = new DefaultUnauthorizedHandler();
    private final JsonWebTokenVerifier tokenVerifier;
    private final JsonWebTokenParser tokenParser;
    @Context
    private HttpServletRequest request;

    public JWTAuthFactory(Authenticator<JsonWebToken, T> authenticator, String realm, Class<T> generatedClass, JsonWebTokenVerifier tokenVerifier, JsonWebTokenParser tokenParser) {
        super(authenticator);
        this.required = false;
        this.realm = realm;
        this.generatedClass = generatedClass;
        this.tokenParser = tokenParser;
        this.tokenVerifier = tokenVerifier;
    }

    private JWTAuthFactory(boolean required, Authenticator<JsonWebToken, T> authenticator, String realm, Class<T> generatedClass, JsonWebTokenVerifier tokenVerifier, JsonWebTokenParser tokenParser) {
        super(authenticator);
        this.required = required;
        this.realm = realm;
        this.generatedClass = generatedClass;
        this.tokenParser = tokenParser;
        this.tokenVerifier = tokenVerifier;
    }

    public JWTAuthFactory<T> prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public JWTAuthFactory<T> responseBuilder(UnauthorizedHandler unauthorizedHandler) {
        this.unauthorizedHandler = unauthorizedHandler;
        return this;
    }

    public AuthFactory<JsonWebToken, T> clone(boolean required) {
        return new JWTAuthFactory<T>(required, this.authenticator(), this.realm, this.generatedClass, this.tokenVerifier, this.tokenParser).prefix(this.prefix).responseBuilder(this.unauthorizedHandler);
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public T provide() {
        block8: {
            if (this.request != null) {
                String header = this.request.getHeader("Authorization");
                try {
                    JsonWebToken token;
                    String method;
                    int space;
                    if (header == null || (space = header.indexOf(32)) <= 0 || !this.prefix.equalsIgnoreCase(method = header.substring(0, space))) break block8;
                    String rawToken = header.substring(space + 1);
                    try {
                        token = this.tokenParser.parse(rawToken);
                        this.tokenVerifier.verifySignature(token);
                    }
                    catch (Exception e) {
                        throw new AuthenticationException(e.getMessage(), (Throwable)e);
                    }
                    Optional result = this.authenticator().authenticate((Object)token);
                    if (result.isPresent()) {
                        return (T)result.get();
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Error decoding credentials", (Throwable)e);
                }
                catch (AuthenticationException e) {
                    LOGGER.warn("Error authenticating credentials", (Throwable)e);
                    throw new InternalServerErrorException();
                }
            }
        }
        if (this.required) {
            throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
        }
        return null;
    }

    public Class<T> getGeneratedClass() {
        return this.generatedClass;
    }
}

