/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.hmac;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenSigner;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSigner;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.KeyAware;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Preconditions;

public class HmacSHA512Signer
extends KeyAware
implements JsonWebTokenSigner {
    private static final String HMAC_SHA512_ALG = "HmacSHA512";

    public HmacSHA512Signer(byte[] secret) {
        super(secret, HMAC_SHA512_ALG);
    }

    @Override
    public String algorithm() {
        return "HS512";
    }

    @Override
    public String sign(JsonWebToken token) {
        Preconditions.checkArgument((boolean)token.header().algorithm().equals("HS512"), (String)"Can not sign a %s with a %s signer", (Object[])new Object[]{token.header().algorithm(), "HS512"});
        return new HmacSigner(this.initialiseMac()).sign(token);
    }
}

