/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.hmac;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenVerifier;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacVerifier;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.KeyAware;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Preconditions;

public class HmacSHA512Verifier
extends KeyAware
implements JsonWebTokenVerifier {
    private static final String HMAC_SHA512_ALG = "HmacSHA512";

    public HmacSHA512Verifier(byte[] secret) {
        super(secret, HMAC_SHA512_ALG);
    }

    @Override
    public String algorithm() {
        return "HS512";
    }

    @Override
    public void verifySignature(JsonWebToken token) {
        Preconditions.checkState((boolean)token.header().algorithm().equals("HS512"));
        new HmacVerifier(this.initialiseMac()).verifySignature(token);
    }
}

