/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.hmac;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenUtils;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.InvalidSignatureException;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;

public class HmacVerifier {
    private final Mac hmac;

    HmacVerifier(Mac hmac) {
        this.hmac = hmac;
    }

    public void verifySignature(JsonWebToken token) {
        Preconditions.checkArgument((boolean)token.getRawToken().isPresent());
        Preconditions.checkNotNull((Object)token.getSignature());
        Preconditions.checkArgument((token.getSignature().length > 0 ? 1 : 0) != 0);
        byte[] calculatedSignature = this.calculateSignatureFor(token);
        byte[] providedSignature = token.getSignature();
        if (!Arrays.equals(calculatedSignature, providedSignature)) {
            throw new InvalidSignatureException();
        }
    }

    private byte[] calculateSignatureFor(JsonWebToken token) {
        List pieces = (List)token.getRawToken().get();
        return this.hmac.doFinal(JsonWebTokenUtils.bytesOf(this.concatenate(pieces)));
    }

    private String concatenate(List<String> pieces) {
        return Joiner.on((String)".").join((Object)pieces.get(0), (Object)pieces.get(1), new Object[0]);
    }
}

