/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.parser;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenUtils;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.MalformedJsonWebTokenException;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultJsonWebTokenParser
implements JsonWebTokenParser {
    @Override
    public JsonWebToken parse(String token) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)token));
        List pieces = Splitter.on((String)".").omitEmptyStrings().trimResults().splitToList((CharSequence)token);
        if (pieces.size() != 3) {
            throw new MalformedJsonWebTokenException(String.format("The supplied token is malformed: [%s]", token));
        }
        String jwtHeader = JsonWebTokenUtils.fromBase64ToString((String)pieces.get(0));
        String jwtClaim = JsonWebTokenUtils.fromBase64ToString((String)pieces.get(1));
        byte[] jwtSignature = JsonWebTokenUtils.fromBase64((String)pieces.get(2));
        return JsonWebToken.parser().header(jwtHeader).claim(jwtClaim).signature(jwtSignature).rawToken(pieces).build();
    }
}

