/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt.validator;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenValidator;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.TokenExpiredException;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Optional;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class ExpiryValidator
implements JsonWebTokenValidator {
    private final Duration acceptableClockSkew;

    public ExpiryValidator(Duration skew) {
        this.acceptableClockSkew = skew;
    }

    public ExpiryValidator() {
        this.acceptableClockSkew = Duration.standardMinutes((long)2L);
    }

    @Override
    public void validate(JsonWebToken token) {
        if (token.claim() != null) {
            Instant issuedAt = (Instant)Optional.fromNullable((Object)this.toInstant(token.claim().issuedAt())).or((Object)this.now());
            Instant expiration = (Instant)Optional.fromNullable((Object)this.toInstant(token.claim().expiration())).or((Object)new Instant(Long.MAX_VALUE));
            Instant notBefore = (Instant)Optional.fromNullable((Object)this.toInstant(token.claim().notBefore())).or((Object)this.now());
            if (issuedAt.isAfter((ReadableInstant)expiration) || notBefore.isAfterNow() || !this.inInterval(issuedAt, expiration)) {
                throw new TokenExpiredException();
            }
        }
    }

    private boolean inInterval(Instant start, Instant end) {
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
        Instant now = this.now();
        Interval currentTimeWithSkew = new Interval((ReadableInstant)now.minus((ReadableDuration)this.acceptableClockSkew), (ReadableInstant)now.plus((ReadableDuration)this.acceptableClockSkew));
        return interval.overlaps((ReadableInterval)currentTimeWithSkew);
    }

    private Instant toInstant(Long input) {
        if (input == null) {
            return null;
        }
        return new Instant(input * 1000L);
    }

    private Instant now() {
        return new Instant();
    }
}

