/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheStats;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.Optional;
import java.util.function.Predicate;
import org.jose4j.jwt.consumer.JwtContext;

public class CachingJwtAuthenticator<P extends Principal>
implements Authenticator<JwtContext, P> {
    private final Authenticator<JwtContext, P> authenticator;
    private final Cache<String, AbstractMap.SimpleEntry<JwtContext, Optional<P>>> cache;
    private final Meter cacheMisses;
    private final Timer gets;

    public CachingJwtAuthenticator(MetricRegistry metricRegistry, Authenticator<JwtContext, P> authenticator, CacheBuilderSpec cacheSpec) {
        this(metricRegistry, authenticator, (CacheBuilder<Object, Object>)CacheBuilder.from((CacheBuilderSpec)cacheSpec));
    }

    public CachingJwtAuthenticator(MetricRegistry metricRegistry, Authenticator<JwtContext, P> authenticator, CacheBuilder<Object, Object> builder) {
        this.authenticator = authenticator;
        this.cacheMisses = metricRegistry.meter(MetricRegistry.name(authenticator.getClass(), (String[])new String[]{"cache-misses"}));
        this.gets = metricRegistry.timer(MetricRegistry.name(authenticator.getClass(), (String[])new String[]{"gets"}));
        this.cache = builder.recordStats().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<P> authenticate(JwtContext context) throws AuthenticationException {
        Timer.Context timer = this.gets.time();
        try {
            AbstractMap.SimpleEntry cacheEntry = (AbstractMap.SimpleEntry)this.cache.getIfPresent((Object)context.getJwt());
            if (cacheEntry != null) {
                Optional optional = (Optional)cacheEntry.getValue();
                return optional;
            }
            this.cacheMisses.mark();
            Optional principal = this.authenticator.authenticate((Object)context);
            if (principal.isPresent()) {
                this.cache.put((Object)context.getJwt(), new AbstractMap.SimpleEntry<JwtContext, Optional>(context, principal));
            }
            Optional optional = principal;
            return optional;
        }
        finally {
            timer.stop();
        }
    }

    public void invalidate(JwtContext credentials) {
        this.cache.invalidate((Object)credentials.getJwt());
    }

    public void invalidateAll(Iterable<JwtContext> credentials) {
        credentials.forEach(context -> this.cache.invalidate((Object)context.getJwt()));
    }

    public void invalidateAll(Predicate<? super JwtContext> predicate) {
        this.cache.asMap().entrySet().stream().map(entry -> (JwtContext)((AbstractMap.SimpleEntry)entry.getValue()).getKey()).filter(predicate::test).map(JwtContext::getJwt).forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.size();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }
}

