/*
 * Decompiled with CFR 0.152.
 */
package com.github.toastshaman.dropwizard.auth.jwt;

import com.google.common.base.Preconditions;
import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.AuthenticationException;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public class JwtAuthFilter<P extends Principal>
extends AuthFilter<JwtContext, P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthFilter.class);
    private final JwtConsumer consumer;
    private final String cookieName;

    private JwtAuthFilter(JwtConsumer consumer, String cookieName) {
        this.consumer = consumer;
        this.cookieName = cookieName;
    }

    public void filter(final ContainerRequestContext requestContext) throws IOException {
        Optional<String> optionalToken = this.getTokenFromCookieOrHeader(requestContext);
        if (optionalToken.isPresent()) {
            try {
                JwtContext jwtContext = this.verifyToken(optionalToken.get());
                final Optional principal = this.authenticator.authenticate((Object)jwtContext);
                if (principal.isPresent()) {
                    requestContext.setSecurityContext(new SecurityContext(){

                        public Principal getUserPrincipal() {
                            return (Principal)principal.get();
                        }

                        public boolean isUserInRole(String role) {
                            return JwtAuthFilter.this.authorizer.authorize((Principal)principal.get(), role);
                        }

                        public boolean isSecure() {
                            return requestContext.getSecurityContext().isSecure();
                        }

                        public String getAuthenticationScheme() {
                            return "BASIC";
                        }
                    });
                    return;
                }
            }
            catch (InvalidJwtException ex) {
                LOGGER.warn("Error decoding credentials: " + ex.getMessage(), (Throwable)ex);
            }
            catch (AuthenticationException ex) {
                LOGGER.warn("Error authenticating credentials", (Throwable)ex);
                throw new InternalServerErrorException();
            }
        }
        throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
    }

    private JwtContext verifyToken(String rawToken) throws InvalidJwtException {
        return this.consumer.process(rawToken);
    }

    private Optional<String> getTokenFromCookieOrHeader(ContainerRequestContext requestContext) {
        Optional<String> headerToken = this.getTokenFromHeader((MultivaluedMap<String, String>)requestContext.getHeaders());
        return headerToken.isPresent() ? headerToken : this.getTokenFromCookie(requestContext);
    }

    private Optional<String> getTokenFromHeader(MultivaluedMap<String, String> headers) {
        String method;
        int space;
        String header = (String)headers.getFirst((Object)"Authorization");
        if (header != null && (space = header.indexOf(32)) > 0 && this.prefix.equalsIgnoreCase(method = header.substring(0, space))) {
            String rawToken = header.substring(space + 1);
            return Optional.of(rawToken);
        }
        return Optional.empty();
    }

    private Optional<String> getTokenFromCookie(ContainerRequestContext requestContext) {
        Map cookies = requestContext.getCookies();
        if (this.cookieName != null && cookies.containsKey(this.cookieName)) {
            Cookie tokenCookie = (Cookie)cookies.get(this.cookieName);
            String rawToken = tokenCookie.getValue();
            return Optional.of(rawToken);
        }
        return Optional.empty();
    }

    public static class Builder<P extends Principal>
    extends AuthFilter.AuthFilterBuilder<JwtContext, P, JwtAuthFilter<P>> {
        private JwtConsumer consumer;
        private String cookieName;

        public Builder<P> setJwtConsumer(JwtConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder<P> setCookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        protected JwtAuthFilter<P> newInstance() {
            Preconditions.checkNotNull((Object)this.consumer, (Object)"JwtConsumer is not set");
            return new JwtAuthFilter(this.consumer, this.cookieName);
        }
    }
}

