/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.autoconfigure;

import com.github.tocrhz.mqtt.autoconfigure.MqttConfigurer;
import com.github.tocrhz.mqtt.autoconfigure.MqttConnector;
import com.github.tocrhz.mqtt.autoconfigure.MqttConversionService;
import com.github.tocrhz.mqtt.autoconfigure.MqttSubscribeProcessor;
import com.github.tocrhz.mqtt.autoconfigure.PayloadJacksonAutoConfiguration;
import com.github.tocrhz.mqtt.properties.MqttProperties;
import com.github.tocrhz.mqtt.publisher.MqttPublisher;
import com.github.tocrhz.mqtt.subscriber.MqttSubscriber;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Order
@AutoConfigureAfter(value={PayloadJacksonAutoConfiguration.class})
@ConditionalOnClass(value={MqttAsyncClient.class})
@ConditionalOnProperty(prefix="mqtt", name={"disable"}, havingValue="false", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttProperties.class})
@Configuration
public class MqttAutoConfiguration {
    private final ConfigurableBeanFactory factory;

    public MqttAutoConfiguration(ListableBeanFactory beanFactory, ConfigurableBeanFactory factory) {
        MqttConversionService.addBeans(beanFactory);
        beanFactory.getBeanDefinitionNames();
        this.factory = factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={MqttConfigurer.class})
    public MqttConfigurer mqttConfigurer() {
        return new MqttConfigurer(){};
    }

    @Bean
    @ConditionalOnMissingBean(value={MqttPublisher.class})
    public MqttPublisher mqttPublisher() {
        return new MqttPublisher();
    }

    @Bean
    @Order
    public MqttConnector mqttConnector(MqttProperties properties, MqttConfigurer configurer) {
        configurer.beforeResolveEmbeddedValue(MqttSubscribeProcessor.SUBSCRIBERS);
        for (MqttSubscriber subscriber : MqttSubscribeProcessor.SUBSCRIBERS) {
            subscriber.afterInit(arg_0 -> ((ConfigurableBeanFactory)this.factory).resolveEmbeddedValue(arg_0));
        }
        configurer.afterResolveEmbeddedValue(MqttSubscribeProcessor.SUBSCRIBERS);
        MqttConnector connector = new MqttConnector();
        connector.start(properties, configurer);
        return connector;
    }
}

