/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.autoconfigure;

import com.github.tocrhz.mqtt.properties.ConnectionProperties;
import com.github.tocrhz.mqtt.properties.MqttProperties;
import com.github.tocrhz.mqtt.subscriber.MqttSubscriber;
import com.github.tocrhz.mqtt.subscriber.TopicPair;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.springframework.util.Assert;

public abstract class MqttConfigurer {
    protected MqttProperties mqttProperties;

    public final void setProperties(MqttProperties mqttProperties) {
        this.mqttProperties = mqttProperties;
        ClientRegistry clientRegistry = new ClientRegistry();
        this.beforeCreate(clientRegistry);
    }

    public void beforeResolveEmbeddedValue(LinkedList<MqttSubscriber> subscribers) {
    }

    public void afterResolveEmbeddedValue(LinkedList<MqttSubscriber> subscribers) {
    }

    public void beforeCreate(ClientRegistry registry) {
    }

    public IMqttAsyncClient postCreate(String clientId, MqttConnectOptions options) throws MqttException {
        return new MqttAsyncClient(options.getServerURIs()[0], clientId, (MqttClientPersistence)new MemoryPersistence());
    }

    public void beforeSubscribe(String clientId, Set<TopicPair> topicPairs) {
    }

    public class ClientRegistry {
        public ClientRegistry disable() {
            MqttConfigurer.this.mqttProperties.setDisable(true);
            return this;
        }

        public ClientRegistry add(String clientId, String ... uri) {
            Assert.notNull((Object)clientId, (String)"clientId can not be null.");
            ConnectionProperties properties = new ConnectionProperties();
            if (uri != null && uri.length > 0) {
                properties.setUri(uri);
            } else {
                properties.setUri(null);
            }
            properties.setClientId(clientId);
            MqttConfigurer.this.mqttProperties.getClients().put(clientId, properties);
            this.resetClientId(clientId);
            return this;
        }

        public ClientRegistry add(String clientId, ConnectionProperties properties) {
            Assert.notNull((Object)clientId, (String)"clientId can not be null.");
            Assert.notNull((Object)properties, (String)"properties can not be null.");
            properties.setClientId(clientId);
            MqttConfigurer.this.mqttProperties.getClients().put(clientId, properties);
            this.resetClientId(clientId);
            return this;
        }

        public ClientRegistry remove(String clientId) {
            Assert.notNull((Object)clientId, (String)"clientId can not be null.");
            MqttConfigurer.this.mqttProperties.getClients().remove(clientId);
            this.resetClientId(clientId);
            return this;
        }

        public ClientRegistry clear() {
            MqttConfigurer.this.mqttProperties.setClientId(null);
            MqttConfigurer.this.mqttProperties.getClients().clear();
            return this;
        }

        public ClientRegistry setDefault(ConnectionProperties properties) {
            MqttConfigurer.this.mqttProperties.setClientId(properties.getClientId());
            MqttConfigurer.this.mqttProperties.setUsername(properties.getUsername());
            MqttConfigurer.this.mqttProperties.setWill(properties.getWill());
            MqttConfigurer.this.mqttProperties.setAutomaticReconnect(properties.getAutomaticReconnect());
            MqttConfigurer.this.mqttProperties.setCleanSession(properties.getCleanSession());
            MqttConfigurer.this.mqttProperties.setConnectionTimeout(properties.getConnectionTimeout());
            MqttConfigurer.this.mqttProperties.setExecutorServiceTimeout(properties.getExecutorServiceTimeout());
            MqttConfigurer.this.mqttProperties.setKeepAliveInterval(properties.getKeepAliveInterval());
            MqttConfigurer.this.mqttProperties.setMaxReconnectDelay(properties.getMaxReconnectDelay());
            MqttConfigurer.this.mqttProperties.setPassword(properties.getPassword());
            MqttConfigurer.this.mqttProperties.setUri(properties.getUri());
            MqttConfigurer.this.mqttProperties.setEnableSharedSubscription(properties.getEnableSharedSubscription());
            MqttConfigurer.this.mqttProperties.setDefaultPublishQos(properties.getDefaultPublishQos());
            return this;
        }

        private void resetClientId(String clientId) {
            if (MqttConfigurer.this.mqttProperties.getClientId() != null && clientId.equals(MqttConfigurer.this.mqttProperties.getClientId())) {
                MqttConfigurer.this.mqttProperties.setClientId(null);
            }
        }
    }
}

