/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.autoconfigure;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;

public class MqttConversionService
extends GenericConversionService {
    private static final Logger log = LoggerFactory.getLogger(MqttConversionService.class);
    private static volatile MqttConversionService sharedInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MqttConversionService getSharedInstance() {
        if (sharedInstance != null) return sharedInstance;
        Class<MqttConversionService> clazz = MqttConversionService.class;
        synchronized (MqttConversionService.class) {
            if (sharedInstance != null) return sharedInstance;
            sharedInstance = new MqttConversionService();
            MqttConversionService.init(sharedInstance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedInstance;
        }
    }

    private static void init(MqttConversionService registry) {
        registry.addConverter(source -> source.getBytes(StandardCharsets.UTF_8));
        registry.addConverter(source -> new String((byte[])source, StandardCharsets.UTF_8));
        registry.addConverter(source -> Boolean.parseBoolean(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Byte.parseByte(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Short.parseShort(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Integer.parseInt(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Long.parseLong(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Float.valueOf(Float.parseFloat(new String((byte[])source, StandardCharsets.UTF_8))));
        registry.addConverter(source -> Double.parseDouble(new String((byte[])source, StandardCharsets.UTF_8)));
    }

    public static void addBeans(ListableBeanFactory beanFactory) {
        MqttConversionService registry = MqttConversionService.getSharedInstance();
        beanFactory.getBeansOfType(ConverterFactory.class).values().forEach(arg_0 -> ((MqttConversionService)registry).addConverterFactory(arg_0));
        beanFactory.getBeansOfType(Converter.class).values().forEach(arg_0 -> ((MqttConversionService)registry).addConverter(arg_0));
        beanFactory.getBeansOfType(GenericConverter.class).values().forEach(arg_0 -> ((MqttConversionService)registry).addConverter(arg_0));
    }

    public byte[] toBytes(Object source) {
        if (source == null) {
            return null;
        }
        byte[] convert = MqttConversionService.toBytes(true, (ConversionService)this, source);
        if (convert == null) {
            convert = MqttConversionService.toBytes(false, ApplicationConversionService.getSharedInstance(), source);
        }
        return convert;
    }

    public Object fromBytes(byte[] source, Class<?> target, List<Converter<Object, Object>> converters) {
        if (source == null) {
            return null;
        }
        Object payload = source;
        if (converters != null && !converters.isEmpty()) {
            for (Converter<Object, Object> converter : converters) {
                try {
                    if (payload == null) {
                        log.warn("Execute covert {} return null.", (Object)converter.getClass().getName());
                        return null;
                    }
                    payload = converter.convert(payload);
                }
                catch (Exception e) {
                    log.error("Execute covert {} failed.", (Object)converter.getClass().getName(), (Object)e);
                    return null;
                }
            }
        }
        if (payload == null) {
            return null;
        }
        Object convert = MqttConversionService.fromBytes(true, (ConversionService)this, source, target);
        if (convert == null) {
            convert = MqttConversionService.fromBytes(false, ApplicationConversionService.getSharedInstance(), source, target);
        }
        return convert;
    }

    private static byte[] toBytes(boolean self, ConversionService service, Object source) {
        Class<?> src = source.getClass();
        try {
            if (src == byte[].class) {
                return (byte[])source;
            }
            if (self && service.canConvert(src, byte[].class)) {
                return (byte[])service.convert(source, byte[].class);
            }
            if (service.canConvert(src, String.class)) {
                String temporary = (String)service.convert(source, String.class);
                if (temporary == null) {
                    log.warn("convert from '{}' to 'java.lang.String' return null.", (Object)src.getName());
                    return null;
                }
                return temporary.getBytes(StandardCharsets.UTF_8);
            }
            log.warn("convert from '{}' to 'byte[]' return null.", (Object)src.getName());
            return null;
        }
        catch (Exception e) {
            log.error("convert from '{}' to 'byte[]' return null.", (Object)src.getName(), (Object)e);
            return null;
        }
    }

    private static Object fromBytes(boolean self, ConversionService service, Object source, Class<?> target) {
        Class<?> src = source.getClass();
        try {
            if (target == src) {
                return source;
            }
            if (self && src == byte[].class && service.canConvert(src, target)) {
                return service.convert(source, target);
            }
            if (src != byte[].class && service.canConvert(src, target)) {
                return service.convert(source, target);
            }
            if (service.canConvert(src, target)) {
                return service.convert(source, target);
            }
            if (service.canConvert(src, String.class) && service.canConvert(String.class, target)) {
                return service.convert(service.convert(source, String.class), target);
            }
            log.warn("convert from {} to {}", (Object)src.getName(), (Object)target.getName());
            return null;
        }
        catch (Exception e) {
            log.error("convert from {} to {}", new Object[]{src.getName(), target.getName(), e});
            return null;
        }
    }
}

