/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.autoconfigure;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.tocrhz.mqtt.autoconfigure.MqttConversionService;
import com.github.tocrhz.mqtt.convert.PayloadDeserialize;
import com.github.tocrhz.mqtt.convert.PayloadSerialize;
import com.github.tocrhz.mqtt.convert.jackson.JacksonPayloadDeserialize;
import com.github.tocrhz.mqtt.convert.jackson.JacksonPayloadSerialize;
import com.github.tocrhz.mqtt.convert.jackson.JacksonStringDeserialize;
import com.github.tocrhz.mqtt.convert.jackson.JacksonStringSerialize;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
@ConditionalOnClass(value={ObjectMapper.class})
@Configuration
public class PayloadJacksonAutoConfiguration {
    public PayloadJacksonAutoConfiguration(ListableBeanFactory beanFactory) {
        MqttConversionService registry = MqttConversionService.getSharedInstance();
        ObjectMapper objectMapper = this.objectMapper();
        Map deserializeMap = beanFactory.getBeansOfType(PayloadDeserialize.class);
        if (deserializeMap.isEmpty()) {
            registry.addConverterFactory(this.jacksonPayloadDeserialize(objectMapper));
            registry.addConverterFactory(this.jacksonStringDeserialize(objectMapper));
        } else {
            deserializeMap.values().forEach(arg_0 -> ((MqttConversionService)registry).addConverterFactory(arg_0));
        }
        Map serializeMap = beanFactory.getBeansOfType(PayloadSerialize.class);
        if (serializeMap.isEmpty()) {
            registry.addConverter(this.jacksonPayloadSerialize(objectMapper));
            registry.addConverter(this.jacksonStringSerialize(objectMapper));
        } else {
            serializeMap.values().forEach(arg_0 -> ((MqttConversionService)registry).addConverter(arg_0));
        }
    }

    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.registerModule((Module)new MqttDefaultJacksonModule());
        return objectMapper;
    }

    public JacksonPayloadSerialize jacksonPayloadSerialize(ObjectMapper objectMapper) {
        return new JacksonPayloadSerialize(objectMapper);
    }

    public JacksonPayloadDeserialize jacksonPayloadDeserialize(ObjectMapper objectMapper) {
        return new JacksonPayloadDeserialize(objectMapper);
    }

    public JacksonStringSerialize jacksonStringSerialize(ObjectMapper objectMapper) {
        return new JacksonStringSerialize(objectMapper);
    }

    public JacksonStringDeserialize jacksonStringDeserialize(ObjectMapper objectMapper) {
        return new JacksonStringDeserialize(objectMapper);
    }

    public static class MqttDefaultJacksonModule
    extends SimpleModule {
        public static final Version VERSION = VersionUtil.parseVersion((String)"1.2.8", (String)"com.github.tocrhz", (String)"mqtt-spring-boot-starter");
        private static final ZoneId ZONE_ID = ZoneId.of("GMT+8");
        private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
        private static final JsonSerializer<LocalDateTime> LOCAL_DATE_TIME_JSON_SERIALIZER = new JsonSerializer<LocalDateTime>(){

            public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                if (value == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(value.atZone(ZONE_ID).format(DATE_TIME_FORMATTER));
                }
            }
        };
        private static final JsonSerializer<LocalDate> LOCAL_DATE_JSON_SERIALIZER = new JsonSerializer<LocalDate>(){

            public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                if (value == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(value.format(DATE_FORMATTER));
                }
            }
        };
        private static final JsonSerializer<LocalTime> LOCAL_TIME_JSON_SERIALIZER = new JsonSerializer<LocalTime>(){

            public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                if (value == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(value.format(TIME_FORMATTER));
                }
            }
        };
        private static final JsonSerializer<Date> DATE_JSON_SERIALIZER = new JsonSerializer<Date>(){

            public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                if (value == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(DATE_TIME_FORMATTER.format(value.toInstant().atZone(ZONE_ID)));
                }
            }
        };
        private static final JsonDeserializer<LocalDateTime> LOCAL_DATE_TIME_JSON_DESERIALIZER = new JsonDeserializer<LocalDateTime>(){

            public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String value = p.getValueAsString();
                if (StringUtils.hasText((String)value)) {
                    return LocalDateTime.parse(value, DATE_TIME_FORMATTER);
                }
                return null;
            }
        };
        private static final JsonDeserializer<LocalDate> LOCAL_DATE_JSON_DESERIALIZER = new JsonDeserializer<LocalDate>(){

            public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String value = p.getValueAsString();
                if (StringUtils.hasText((String)value)) {
                    return LocalDate.parse(value, DATE_FORMATTER);
                }
                return null;
            }
        };
        private static final JsonDeserializer<LocalTime> LOCAL_TIME_JSON_DESERIALIZER = new JsonDeserializer<LocalTime>(){

            public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String value = p.getValueAsString();
                if (StringUtils.hasText((String)value)) {
                    return LocalTime.parse(value, TIME_FORMATTER);
                }
                return null;
            }
        };
        private static final JsonDeserializer<Date> DATE_JSON_DESERIALIZER = new JsonDeserializer<Date>(){

            public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String value = p.getValueAsString();
                if (StringUtils.hasText((String)value)) {
                    return Date.from(LocalDateTime.parse(value, DATE_TIME_FORMATTER).atZone(ZONE_ID).toInstant());
                }
                return null;
            }
        };

        public MqttDefaultJacksonModule() {
            super(VERSION);
            this.addSerializer(LocalDateTime.class, LOCAL_DATE_TIME_JSON_SERIALIZER);
            this.addSerializer(LocalDate.class, LOCAL_DATE_JSON_SERIALIZER);
            this.addSerializer(LocalTime.class, LOCAL_TIME_JSON_SERIALIZER);
            this.addSerializer(Date.class, DATE_JSON_SERIALIZER);
            this.addDeserializer(LocalDateTime.class, LOCAL_DATE_TIME_JSON_DESERIALIZER);
            this.addDeserializer(LocalDate.class, LOCAL_DATE_JSON_DESERIALIZER);
            this.addDeserializer(LocalTime.class, LOCAL_TIME_JSON_DESERIALIZER);
            this.addDeserializer(Date.class, DATE_JSON_DESERIALIZER);
        }
    }
}

