/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.convert.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tocrhz.mqtt.convert.PayloadDeserialize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class JacksonPayloadDeserialize
implements PayloadDeserialize {
    private static final Logger log = LoggerFactory.getLogger(JacksonPayloadDeserialize.class);
    private final ObjectMapper objectMapper;

    public JacksonPayloadDeserialize(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> Converter<byte[], T> getConverter(Class<T> targetType) {
        return source -> {
            try {
                if (targetType == byte[].class) {
                    return source;
                }
                if (targetType == String.class) {
                    return new String((byte[])source, StandardCharsets.UTF_8);
                }
                return this.objectMapper.readValue(source, targetType);
            }
            catch (IOException e) {
                log.warn("Payload deserialize error: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        };
    }
}

