/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.properties;

import com.github.tocrhz.mqtt.properties.ConnectionProperties;
import com.github.tocrhz.mqtt.properties.WillProperties;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="mqtt")
public class MqttProperties
extends ConnectionProperties {
    private Boolean disable = false;
    private Map<String, ConnectionProperties> clients = new LinkedHashMap<String, ConnectionProperties>();

    public Boolean getDisable() {
        return this.disable;
    }

    public void setDisable(Boolean disable) {
        this.disable = disable;
    }

    public Map<String, ConnectionProperties> getClients() {
        return this.clients;
    }

    public void setClients(Map<String, ConnectionProperties> clients) {
        this.clients = clients;
    }

    public void forEach(BiConsumer<String, MqttConnectOptions> biConsumer) {
        MqttConnectOptions defaultOptions = this.toOptions();
        if (defaultOptions != null) {
            biConsumer.accept(this.getClientId(), defaultOptions);
        }
        if (this.clients != null && !this.clients.isEmpty()) {
            String[] clientIds;
            for (String clientId : clientIds = this.clients.keySet().toArray(new String[0])) {
                ConnectionProperties properties = this.clients.get(clientId);
                String localClientId = properties.getClientId();
                if (StringUtils.hasText((String)localClientId) && !localClientId.equals(clientId)) {
                    this.clients.remove(clientId);
                    this.clients.put(localClientId, properties);
                    continue;
                }
                properties.setClientId(clientId);
            }
            this.clients.forEach((? super K id, ? super V prop) -> {
                MqttConnectOptions options = this.toOptions((String)id);
                if (options != null) {
                    biConsumer.accept((String)id, options);
                }
            });
        }
    }

    private MqttConnectOptions toOptions() {
        if (StringUtils.hasText((String)this.getClientId())) {
            return this.toOptions(this.getClientId());
        }
        return null;
    }

    public MqttConnectOptions toOptions(String clientId) {
        ConnectionProperties properties = this.clients.get(clientId);
        if (properties == null) {
            if (clientId.equals(this.getClientId())) {
                properties = this;
            } else {
                return null;
            }
        }
        this.merge(properties);
        return this.toOptions(properties);
    }

    private MqttConnectOptions toOptions(ConnectionProperties properties) {
        WillProperties will;
        MqttConnectOptions options = new MqttConnectOptions();
        options.setMaxReconnectDelay(properties.getMaxReconnectDelay() * 1000);
        options.setKeepAliveInterval(properties.getKeepAliveInterval().intValue());
        options.setConnectionTimeout(properties.getConnectionTimeout().intValue());
        options.setCleanSession(properties.getCleanSession().booleanValue());
        options.setAutomaticReconnect(properties.getAutomaticReconnect().booleanValue());
        options.setExecutorServiceTimeout(properties.getExecutorServiceTimeout().intValue());
        options.setServerURIs(properties.getUri());
        if (StringUtils.hasText((String)properties.getUsername()) && StringUtils.hasText((String)properties.getPassword())) {
            options.setUserName(properties.getUsername());
            options.setPassword(properties.getPassword().toCharArray());
        }
        if (properties.getWill() != null && StringUtils.hasText((String)(will = properties.getWill()).getTopic()) && StringUtils.hasText((String)will.getPayload())) {
            options.setWill(will.getTopic(), will.getPayload().getBytes(StandardCharsets.UTF_8), will.getQos().intValue(), will.getRetained().booleanValue());
        }
        return options;
    }

    private void merge(ConnectionProperties target) {
        target.setUri(this.mergeValue(this.getUri(), target.getUri(), new String[]{"tcp://127.0.0.1:1883"}));
        target.setUsername(this.mergeValue(this.getUsername(), target.getUsername(), null));
        target.setPassword(this.mergeValue(this.getPassword(), target.getPassword(), null));
        target.setDefaultPublishQos(this.mergeValue(this.getDefaultPublishQos(), target.getDefaultPublishQos(), 0));
        target.setMaxReconnectDelay(this.mergeValue(this.getMaxReconnectDelay(), target.getMaxReconnectDelay(), 60));
        target.setKeepAliveInterval(this.mergeValue(this.getKeepAliveInterval(), target.getKeepAliveInterval(), 60));
        target.setConnectionTimeout(this.mergeValue(this.getConnectionTimeout(), target.getConnectionTimeout(), 30));
        target.setExecutorServiceTimeout(this.mergeValue(this.getExecutorServiceTimeout(), target.getExecutorServiceTimeout(), 10));
        target.setCleanSession(this.mergeValue(this.getCleanSession(), target.getCleanSession(), true));
        target.setAutomaticReconnect(this.mergeValue(this.getAutomaticReconnect(), target.getAutomaticReconnect(), true));
        target.setWill(this.mergeValue(this.getWill(), target.getWill(), null));
        target.setEnableSharedSubscription(this.mergeValue(this.getEnableSharedSubscription(), target.getEnableSharedSubscription(), true));
        if (target.getWill() != null && this.getWill() != null) {
            WillProperties will = this.getWill();
            WillProperties targetWill = target.getWill();
            targetWill.setTopic(this.mergeValue(will.getTopic(), targetWill.getTopic(), null));
            targetWill.setPayload(this.mergeValue(will.getPayload(), targetWill.getPayload(), null));
            targetWill.setQos(this.mergeValue(will.getQos(), targetWill.getQos(), 0));
            targetWill.setRetained(this.mergeValue(will.getRetained(), targetWill.getRetained(), false));
        }
    }

    private <T> T mergeValue(T parentValue, T targetValue, T defaultValue) {
        if (parentValue == null && targetValue == null) {
            return defaultValue;
        }
        if (targetValue == null) {
            return parentValue;
        }
        return targetValue;
    }

    public boolean isSharedEnable(String clientId) {
        if (clientId.equals(this.getClientId())) {
            return this.getEnableSharedSubscription();
        }
        ConnectionProperties properties = this.clients.get(clientId);
        if (properties == null) {
            return false;
        }
        return properties.getEnableSharedSubscription();
    }

    public int getDefaultPublishQos(String clientId) {
        if (clientId.equals(this.getClientId())) {
            return this.getDefaultPublishQos();
        }
        ConnectionProperties properties = this.clients.get(clientId);
        if (properties == null) {
            return 0;
        }
        return properties.getDefaultPublishQos();
    }
}

