/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.publisher;

import com.github.tocrhz.mqtt.autoconfigure.MqttConnector;
import com.github.tocrhz.mqtt.autoconfigure.MqttConversionService;
import java.util.Objects;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MqttPublisher {
    private static final Logger log = LoggerFactory.getLogger(MqttPublisher.class);

    public void send(String topic, Object payload) {
        this.send(MqttConnector.DefaultClientId, topic, payload, MqttConnector.DefaultPublishQos, false, null);
    }

    public void send(String topic, Object payload, IMqttActionListener callback) {
        this.send(MqttConnector.DefaultClientId, topic, payload, MqttConnector.DefaultPublishQos, false, callback);
    }

    public void send(String clientId, String topic, Object payload) {
        this.send(clientId, topic, payload, MqttConnector.getDefaultQosById(clientId), false, null);
    }

    public void send(String clientId, String topic, Object payload, IMqttActionListener callback) {
        this.send(clientId, topic, payload, MqttConnector.getDefaultQosById(clientId), false, callback);
    }

    public void send(String topic, Object payload, int qos, boolean retained) {
        this.send(MqttConnector.DefaultClientId, topic, payload, qos, retained, null);
    }

    public void send(String clientId, String topic, Object payload, int qos, boolean retained) {
        this.send(clientId, topic, payload, qos, retained, null);
    }

    public void send(String topic, Object payload, int qos, boolean retained, IMqttActionListener callback) {
        this.send(MqttConnector.DefaultClientId, topic, payload, qos, retained, callback);
    }

    public void send(String clientId, String topic, Object payload, int qos, boolean retained, IMqttActionListener callback) {
        Assert.isTrue((topic != null && !topic.trim().isEmpty() ? 1 : 0) != 0, (String)"topic cannot be blank.");
        IMqttAsyncClient client = Objects.requireNonNull(MqttConnector.getClientById(clientId));
        byte[] bytes = MqttConversionService.getSharedInstance().toBytes(payload);
        if (bytes == null) {
            return;
        }
        MqttMessage message = this.toMessage(bytes, qos, retained);
        try {
            client.publish(topic, message, null, callback);
        }
        catch (Throwable throwable) {
            log.error("message publish error: {}", (Object)throwable.getMessage(), (Object)throwable);
        }
    }

    private MqttMessage toMessage(byte[] payload, int qos, boolean retained) {
        MqttMessage message = new MqttMessage();
        message.setPayload(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return message;
    }
}

