/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.http.GenericHttpUriRequest;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ssl.HostVerifyingSSLSocketFactory;
import com.github.tomakehurst.wiremock.http.ssl.SSLContextBuilder;
import com.github.tomakehurst.wiremock.http.ssl.TrustEverythingStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustSelfSignedStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustSpecificHostsStrategy;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import wiremock.org.apache.commons.lang3.StringUtils;
import wiremock.org.apache.http.HttpHost;
import wiremock.org.apache.http.HttpResponse;
import wiremock.org.apache.http.auth.AuthScope;
import wiremock.org.apache.http.auth.UsernamePasswordCredentials;
import wiremock.org.apache.http.client.config.RequestConfig;
import wiremock.org.apache.http.client.methods.HttpDelete;
import wiremock.org.apache.http.client.methods.HttpGet;
import wiremock.org.apache.http.client.methods.HttpHead;
import wiremock.org.apache.http.client.methods.HttpOptions;
import wiremock.org.apache.http.client.methods.HttpPatch;
import wiremock.org.apache.http.client.methods.HttpPost;
import wiremock.org.apache.http.client.methods.HttpPut;
import wiremock.org.apache.http.client.methods.HttpTrace;
import wiremock.org.apache.http.client.methods.HttpUriRequest;
import wiremock.org.apache.http.config.SocketConfig;
import wiremock.org.apache.http.conn.ConnectionKeepAliveStrategy;
import wiremock.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import wiremock.org.apache.http.conn.ssl.NoopHostnameVerifier;
import wiremock.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import wiremock.org.apache.http.impl.NoConnectionReuseStrategy;
import wiremock.org.apache.http.impl.client.BasicCredentialsProvider;
import wiremock.org.apache.http.impl.client.CloseableHttpClient;
import wiremock.org.apache.http.impl.client.HttpClientBuilder;
import wiremock.org.apache.http.impl.client.ProxyAuthenticationStrategy;
import wiremock.org.apache.http.protocol.HttpContext;
import wiremock.org.apache.http.util.TextUtils;

public class HttpClientFactory {
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final int DEFAULT_TIMEOUT = 30000;
    private static final ConnectionKeepAliveStrategy NO_KEEP_ALIVE = new ConnectionKeepAliveStrategy(){

        @Override
        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            return 0L;
        }
    };

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean trustSelfSignedCertificates, List<String> trustedHosts, boolean useSystemProperties) {
        HttpClientBuilder builder = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().setMaxConnTotal(maxConnections).setMaxConnPerRoute(maxConnections).setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(true).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeoutMilliseconds).build()).setConnectionReuseStrategy(NoConnectionReuseStrategy.INSTANCE).setKeepAliveStrategy(NO_KEEP_ALIVE);
        if (useSystemProperties) {
            builder.useSystemProperties();
        }
        if (proxySettings != ProxySettings.NO_PROXY) {
            HttpHost proxyHost = new HttpHost(proxySettings.host(), proxySettings.port());
            builder.setProxy(proxyHost);
            if (!StringUtils.isEmpty(proxySettings.getUsername()) && !StringUtils.isEmpty(proxySettings.getPassword())) {
                builder.setProxyAuthenticationStrategy(new ProxyAuthenticationStrategy());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxySettings.host(), proxySettings.port()), new UsernamePasswordCredentials(proxySettings.getUsername(), proxySettings.getPassword()));
                builder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        SSLContext sslContext = HttpClientFactory.buildSslContext(trustStoreSettings, trustSelfSignedCertificates, trustedHosts);
        LayeredConnectionSocketFactory sslSocketFactory = HttpClientFactory.buildSslConnectionSocketFactory(sslContext);
        builder.setSSLSocketFactory(sslSocketFactory);
        return builder.build();
    }

    private static LayeredConnectionSocketFactory buildSslConnectionSocketFactory(SSLContext sslContext) {
        String[] supportedProtocols = HttpClientFactory.split(System.getProperty("https.protocols"));
        String[] supportedCipherSuites = HttpClientFactory.split(System.getProperty("https.cipherSuites"));
        return new SSLConnectionSocketFactory((SSLSocketFactory)new HostVerifyingSSLSocketFactory(sslContext.getSocketFactory()), supportedProtocols, supportedCipherSuites, (HostnameVerifier)new NoopHostnameVerifier());
    }

    private static String[] split(String s2) {
        if (TextUtils.isBlank(s2)) {
            return null;
        }
        return s2.split(" *, *");
    }

    private static SSLContext buildSslContext(KeyStoreSettings trustStoreSettings, boolean trustSelfSignedCertificates, List<String> trustedHosts) {
        if (trustStoreSettings != KeyStoreSettings.NO_STORE) {
            return HttpClientFactory.buildSSLContextWithTrustStore(trustStoreSettings, trustSelfSignedCertificates, trustedHosts);
        }
        if (trustSelfSignedCertificates) {
            return HttpClientFactory.buildAllowAnythingSSLContext();
        }
        try {
            return SSLContextBuilder.create().loadTrustMaterial(new TrustSpecificHostsStrategy(trustedHosts)).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return (SSLContext)Exceptions.throwUnchecked(e, null);
        }
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean useSystemProperties) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, proxySettings, trustStoreSettings, true, Collections.emptyList(), useSystemProperties);
    }

    private static SSLContext buildSSLContextWithTrustStore(KeyStoreSettings trustStoreSettings, boolean trustSelfSignedCertificates, List<String> trustedHosts) {
        try {
            KeyStore trustStore = trustStoreSettings.loadStore();
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create().loadKeyMaterial(trustStore, trustStoreSettings.password().toCharArray());
            if (trustSelfSignedCertificates) {
                sslContextBuilder.loadTrustMaterial(new TrustSelfSignedStrategy());
            } else if (HttpClientFactory.containsCertificate(trustStore)) {
                sslContextBuilder.loadTrustMaterial(trustStore, new TrustSpecificHostsStrategy(trustedHosts));
            } else {
                sslContextBuilder.loadTrustMaterial(new TrustSpecificHostsStrategy(trustedHosts));
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, SSLContext.class);
        }
    }

    private static boolean containsCertificate(KeyStore trustStore) throws KeyStoreException {
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                if (!(trustStore.getEntry(alias, null) instanceof KeyStore.TrustedCertificateEntry)) continue;
                return true;
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            }
        }
        return false;
    }

    private static SSLContext buildAllowAnythingSSLContext() {
        try {
            return SSLContextBuilder.create().loadTrustMaterial(new TrustEverythingStrategy()).build();
        }
        catch (Exception e) {
            return (SSLContext)Exceptions.throwUnchecked(e, null);
        }
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, ProxySettings.NO_PROXY, KeyStoreSettings.NO_STORE, true);
    }

    public static CloseableHttpClient createClient(int timeoutMilliseconds) {
        return HttpClientFactory.createClient(50, timeoutMilliseconds);
    }

    public static CloseableHttpClient createClient(ProxySettings proxySettings) {
        return HttpClientFactory.createClient(50, 30000, proxySettings, KeyStoreSettings.NO_STORE, true);
    }

    public static CloseableHttpClient createClient() {
        return HttpClientFactory.createClient(30000);
    }

    public static HttpUriRequest getHttpRequestFor(RequestMethod method, String url) {
        LocalNotifier.notifier().info("Proxying: " + method + " " + url);
        if (method.equals(RequestMethod.GET)) {
            return new HttpGet(url);
        }
        if (method.equals(RequestMethod.POST)) {
            return new HttpPost(url);
        }
        if (method.equals(RequestMethod.PUT)) {
            return new HttpPut(url);
        }
        if (method.equals(RequestMethod.DELETE)) {
            return new HttpDelete(url);
        }
        if (method.equals(RequestMethod.HEAD)) {
            return new HttpHead(url);
        }
        if (method.equals(RequestMethod.OPTIONS)) {
            return new HttpOptions(url);
        }
        if (method.equals(RequestMethod.TRACE)) {
            return new HttpTrace(url);
        }
        if (method.equals(RequestMethod.PATCH)) {
            return new HttpPatch(url);
        }
        return new GenericHttpUriRequest(method.toString(), url);
    }
}

